/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import net.finmath.exception.CalculationException;
import net.finmath.marketdata.model.curves.DiscountCurve;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.modelling.products.Swaption;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractTermStructureMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.Swaption;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.RegularSchedule;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class SwaptionATM
extends AbstractTermStructureMonteCarloProduct
implements net.finmath.modelling.products.Swaption {
    private final TimeDiscretization tenor;
    private final Swaption.ValueUnit valueUnit;

    public SwaptionATM(double[] swapTenor, Swaption.ValueUnit valueUnit) {
        this.tenor = new TimeDiscretizationFromArray(swapTenor);
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        ForwardCurve forwardCurve = model.getModel().getForwardRateCurve();
        DiscountCurve discountCurve = model.getModel().getAnalyticModel() != null ? model.getModel().getAnalyticModel().getDiscountCurve(forwardCurve.getDiscountCurveName()) : null;
        double optionMaturity = this.tenor.getTime(0);
        double swapAnnuity = discountCurve != null ? SwapAnnuity.getSwapAnnuity(this.tenor, discountCurve) : SwapAnnuity.getSwapAnnuity(this.tenor, forwardCurve);
        double parSwapRate = Swap.getForwardSwapRate(new RegularSchedule(this.tenor), new RegularSchedule(this.tenor), forwardCurve, model.getModel().getAnalyticModel());
        Swaption swaption = new Swaption(this.tenor.getTime(0), this.tenor, parSwapRate);
        RandomVariable optionValue = swaption.getValue(evaluationTime, model);
        switch (this.valueUnit) {
            case VALUE: {
                return optionValue;
            }
            case VOLATILITYNORMAL: {
                return this.getImpliedBachelierATMOptionVolatility(optionValue, optionMaturity, swapAnnuity);
            }
            case INTEGRATEDVARIANCENORMAL: 
            case INTEGRATEDNORMALVARIANCE: {
                return this.getImpliedBachelierATMOptionVolatility(optionValue, optionMaturity, swapAnnuity).squared().mult(optionMaturity);
            }
        }
        throw new IllegalArgumentException("Unknown valueUnit: " + this.valueUnit.name());
    }

    public RandomVariable getImpliedBachelierATMOptionVolatility(RandomVariable optionValue, double optionMaturity, double swapAnnuity) {
        return optionValue.average().mult(Math.sqrt(Math.PI * 2 / optionMaturity) / swapAnnuity);
    }
}

