/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.HashMap;
import java.util.Map;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.modelling.products.Swaption;
import net.finmath.montecarlo.interestrate.LIBORMarketModel;
import net.finmath.montecarlo.interestrate.TermStructureModel;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractTermStructureMonteCarloProduct;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;
import net.finmath.time.TimeDiscretization;

public class SwaptionSingleCurveAnalyticApproximation
extends AbstractTermStructureMonteCarloProduct
implements Swaption {
    private final double swaprate;
    private final double[] swapTenor;
    private final Swaption.ValueUnit valueUnit;

    public SwaptionSingleCurveAnalyticApproximation(double swaprate, TimeDiscretization swapTenor) {
        this(swaprate, swapTenor.getAsDoubleArray(), Swaption.ValueUnit.VALUE);
    }

    public SwaptionSingleCurveAnalyticApproximation(double swaprate, double[] swapTenor, Swaption.ValueUnit valueUnit) {
        this.swaprate = swaprate;
        this.swapTenor = swapTenor;
        this.valueUnit = valueUnit;
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) {
        TermStructureModel modelBase = model.getModel();
        if (modelBase instanceof LIBORMarketModel) {
            return this.getValues(evaluationTime, model.getTimeDiscretization(), (LIBORMarketModel)modelBase);
        }
        throw new IllegalArgumentException("This product requires a simulation where the underlying model is of type LIBORMarketModel.");
    }

    public RandomVariable getValues(double evaluationTime, TimeDiscretization timeDiscretization, LIBORMarketModel model) {
        if (evaluationTime > 0.0) {
            throw new RuntimeException("Forward start evaluation currently not supported.");
        }
        double swapStart = this.swapTenor[0];
        double swapEnd = this.swapTenor[this.swapTenor.length - 1];
        int swapStartIndex = model.getLiborPeriodIndex(swapStart);
        int swapEndIndex = model.getLiborPeriodIndex(swapEnd);
        int optionMaturityIndex = model.getCovarianceModel().getTimeDiscretization().getTimeIndex(swapStart) - 1;
        Map<String, double[]> logSwaprateDerivative = SwaptionSingleCurveAnalyticApproximation.getLogSwaprateDerivative(model.getLiborPeriodDiscretization(), model.getForwardRateCurve(), this.swapTenor);
        double[] swapCovarianceWeights = logSwaprateDerivative.get("values");
        double[] discountFactors = logSwaprateDerivative.get("discountFactors");
        double[] swapAnnuities = logSwaprateDerivative.get("swapAnnuities");
        double[][] integratedLIBORCovariance = model.getIntegratedLIBORCovariance(timeDiscretization)[optionMaturityIndex];
        double integratedSwapRateVariance = 0.0;
        for (int componentIndex1 = swapStartIndex; componentIndex1 < swapEndIndex; ++componentIndex1) {
            for (int componentIndex2 = componentIndex1 + 1; componentIndex2 < swapEndIndex; ++componentIndex2) {
                integratedSwapRateVariance += 2.0 * swapCovarianceWeights[componentIndex1 - swapStartIndex] * swapCovarianceWeights[componentIndex2 - swapStartIndex] * integratedLIBORCovariance[componentIndex1][componentIndex2];
            }
            integratedSwapRateVariance += swapCovarianceWeights[componentIndex1 - swapStartIndex] * swapCovarianceWeights[componentIndex1 - swapStartIndex] * integratedLIBORCovariance[componentIndex1][componentIndex1];
        }
        if (this.valueUnit == Swaption.ValueUnit.INTEGRATEDVARIANCELOGNORMAL || this.valueUnit == Swaption.ValueUnit.INTEGRATEDVARIANCE) {
            return new Scalar(integratedSwapRateVariance);
        }
        double volatility = Math.sqrt(integratedSwapRateVariance / swapStart);
        if (this.valueUnit == Swaption.ValueUnit.VOLATILITYLOGNORMAL || this.valueUnit == Swaption.ValueUnit.VOLATILITY) {
            return new Scalar(volatility);
        }
        double swapAnnuity = swapAnnuities[0];
        double parSwaprate = (discountFactors[0] - discountFactors[swapEndIndex - swapStartIndex]) / swapAnnuity;
        double optionMaturity = swapStart;
        double valueSwaption = AnalyticFormulas.blackModelSwaptionValue(parSwaprate, volatility, optionMaturity, this.swaprate, swapAnnuity);
        return new Scalar(valueSwaption);
    }

    public static Map<String, double[]> getLogSwaprateDerivative(TimeDiscretization liborPeriodDiscretization, ForwardCurve forwardCurve, double[] swapTenor) {
        double liborPeriodLength;
        double libor;
        int liborPeriodIndex;
        double swapStart = swapTenor[0];
        double swapEnd = swapTenor[swapTenor.length - 1];
        int swapStartIndex = liborPeriodDiscretization.getTimeIndex(swapStart);
        int swapEndIndex = liborPeriodDiscretization.getTimeIndex(swapEnd);
        double[] forwardRates = new double[swapEndIndex - swapStartIndex + 1];
        double[] discountFactors = new double[swapEndIndex - swapStartIndex + 1];
        discountFactors[0] = 1.0;
        for (liborPeriodIndex = 0; liborPeriodIndex < swapStartIndex; ++liborPeriodIndex) {
            libor = forwardCurve.getForward(null, liborPeriodDiscretization.getTime(liborPeriodIndex));
            liborPeriodLength = liborPeriodDiscretization.getTimeStep(liborPeriodIndex);
            discountFactors[0] = discountFactors[0] / (1.0 + libor * liborPeriodLength);
        }
        for (liborPeriodIndex = swapStartIndex; liborPeriodIndex < swapEndIndex; ++liborPeriodIndex) {
            libor = forwardCurve.getForward(null, liborPeriodDiscretization.getTime(liborPeriodIndex));
            liborPeriodLength = liborPeriodDiscretization.getTimeStep(liborPeriodIndex);
            forwardRates[liborPeriodIndex - swapStartIndex] = libor;
            discountFactors[liborPeriodIndex - swapStartIndex + 1] = discountFactors[liborPeriodIndex - swapStartIndex] / (1.0 + libor * liborPeriodLength);
        }
        double[] swapAnnuities = new double[swapTenor.length - 1];
        double swapAnnuity = 0.0;
        for (int swapPeriodIndex = swapTenor.length - 2; swapPeriodIndex >= 0; --swapPeriodIndex) {
            int periodEndIndex = liborPeriodDiscretization.getTimeIndex(swapTenor[swapPeriodIndex + 1]);
            swapAnnuities[swapPeriodIndex] = swapAnnuity += discountFactors[periodEndIndex - swapStartIndex] * (swapTenor[swapPeriodIndex + 1] - swapTenor[swapPeriodIndex]);
        }
        double longForwardRate = discountFactors[swapEndIndex - swapStartIndex] / (discountFactors[0] - discountFactors[swapEndIndex - swapStartIndex]);
        double[] swapCovarianceWeights = new double[swapEndIndex - swapStartIndex];
        int swapPeriodIndex = 0;
        for (int liborPeriodIndex2 = swapStartIndex; liborPeriodIndex2 < swapEndIndex; ++liborPeriodIndex2) {
            if (liborPeriodDiscretization.getTime(liborPeriodIndex2) >= swapTenor[swapPeriodIndex + 1]) {
                ++swapPeriodIndex;
            }
            swapCovarianceWeights[liborPeriodIndex2 - swapStartIndex] = (longForwardRate + swapAnnuities[swapPeriodIndex] / swapAnnuity) * (1.0 - discountFactors[liborPeriodIndex2 - swapStartIndex + 1] / discountFactors[liborPeriodIndex2 - swapStartIndex]);
        }
        HashMap<String, double[]> results = new HashMap<String, double[]>();
        results.put("values", swapCovarianceWeights);
        results.put("discountFactors", discountFactors);
        results.put("swapAnnuities", swapAnnuities);
        return results;
    }
}

