/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products;

import java.util.ArrayList;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.AbstractTermStructureMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.TermStructureMonteCarloProduct;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.components.NotionalFromConstant;
import net.finmath.montecarlo.interestrate.products.components.Option;
import net.finmath.montecarlo.interestrate.products.components.Period;
import net.finmath.montecarlo.interestrate.products.components.ProductCollection;
import net.finmath.montecarlo.interestrate.products.indices.FixedCoupon;
import net.finmath.montecarlo.interestrate.products.indices.LIBORIndex;
import net.finmath.stochastic.RandomVariable;

public class SwaptionWithComponents
extends AbstractTermStructureMonteCarloProduct {
    private final TermStructureMonteCarloProduct option;

    public SwaptionWithComponents(double exerciseDate, double[] fixingDates, double[] paymentDates, double[] swaprates) {
        ArrayList<AbstractProductComponent> legs = new ArrayList<AbstractProductComponent>();
        NotionalFromConstant notional = new NotionalFromConstant(1.0);
        ArrayList<AbstractProductComponent> fixedLegPeriods = new ArrayList<AbstractProductComponent>();
        for (int periodIndex = 0; periodIndex < fixingDates.length; ++periodIndex) {
            double daycountFraction = paymentDates[periodIndex] - fixingDates[periodIndex];
            Period period = new Period(fixingDates[periodIndex], paymentDates[periodIndex], fixingDates[periodIndex], paymentDates[periodIndex], notional, new FixedCoupon(swaprates[periodIndex]), daycountFraction, true, true, true, false);
            fixedLegPeriods.add(period);
        }
        ProductCollection fixedLeg = new ProductCollection(fixedLegPeriods);
        legs.add(fixedLeg);
        ArrayList<AbstractProductComponent> floatingLegPeriods = new ArrayList<AbstractProductComponent>();
        for (int periodIndex = 0; periodIndex < fixingDates.length; ++periodIndex) {
            double daycountFraction = paymentDates[periodIndex] - fixingDates[periodIndex];
            double periodLength = paymentDates[periodIndex] - fixingDates[periodIndex];
            Period period = new Period(fixingDates[periodIndex], paymentDates[periodIndex], fixingDates[periodIndex], paymentDates[periodIndex], notional, new LIBORIndex(0.0, periodLength), daycountFraction, true, true, false, false);
            floatingLegPeriods.add(period);
        }
        ProductCollection floatingLeg = new ProductCollection(floatingLegPeriods);
        legs.add(floatingLeg);
        ProductCollection underlying = new ProductCollection(legs);
        this.option = new Option(exerciseDate, underlying);
    }

    @Override
    public RandomVariable getValue(double evaluationTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        RandomVariable values = this.option.getValue(evaluationTime, model);
        return values;
    }
}

