/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.components;

import java.time.LocalDateTime;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.components.AbstractProductComponent;
import net.finmath.montecarlo.interestrate.products.components.Notional;
import net.finmath.stochastic.RandomVariable;

public abstract class AbstractPeriod
extends AbstractProductComponent {
    private static final long serialVersionUID = 8035860121112226049L;
    private final LocalDateTime referenceDate;
    private final double periodStart;
    private final double periodEnd;
    private final double fixingDate;
    private final double paymentDate;
    private final Notional notional;
    private final AbstractProductComponent index;
    private final double daycountFraction;

    @Override
    public abstract RandomVariable getValue(double var1, TermStructureMonteCarloSimulationModel var3) throws CalculationException;

    public abstract RandomVariable getCoupon(double var1, TermStructureMonteCarloSimulationModel var3) throws CalculationException;

    public AbstractPeriod(LocalDateTime referenceDate, double periodStart, double periodEnd, double fixingDate, double paymentDate, Notional notional, AbstractProductComponent index, double daycountFraction) {
        this.referenceDate = referenceDate;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
        this.fixingDate = fixingDate;
        this.paymentDate = paymentDate;
        this.notional = notional;
        this.index = index;
        this.daycountFraction = daycountFraction;
    }

    public AbstractPeriod(double periodStart, double periodEnd, double fixingDate, double paymentDate, Notional notional, AbstractProductComponent index, double daycountFraction) {
        this(null, periodStart, periodEnd, fixingDate, paymentDate, notional, index, daycountFraction);
    }

    public AbstractPeriod(double periodStart, double periodEnd, double fixingDate, double paymentDate, Notional notional, AbstractProductComponent index) {
        this(periodStart, periodEnd, fixingDate, paymentDate, notional, index, periodEnd - periodStart);
    }

    @Override
    public String getCurrency() {
        return this.notional.getCurrency();
    }

    public LocalDateTime getReferenceDate() {
        return this.referenceDate;
    }

    public double getPeriodStart() {
        return this.periodStart;
    }

    public double getPeriodEnd() {
        return this.periodEnd;
    }

    public double getFixingDate() {
        return this.fixingDate;
    }

    public double getPaymentDate() {
        return this.paymentDate;
    }

    public Notional getNotional() {
        return this.notional;
    }

    public AbstractProductComponent getIndex() {
        return this.index;
    }

    public double getDaycountFraction() {
        return this.daycountFraction;
    }

    @Override
    public Set<String> queryUnderlyings() {
        return this.getIndex().queryUnderlyings();
    }

    @Override
    public String toString() {
        return "AbstractPeriod [periodStart=" + this.periodStart + ", periodEnd=" + this.periodEnd + ", fixingDate=" + this.fixingDate + ", paymentDate=" + this.paymentDate + ", notional=" + this.notional + ", index=" + this.index + ", daycountFraction=" + this.daycountFraction + "]";
    }
}

