/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.products.indices;

import java.time.LocalDate;
import java.util.Set;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.interestrate.TermStructureMonteCarloSimulationModel;
import net.finmath.montecarlo.interestrate.products.indices.AbstractIndex;
import net.finmath.stochastic.RandomVariable;

public class DateIndex
extends AbstractIndex {
    private static final long serialVersionUID = 7457336500162149869L;
    private final DateIndexType dateIndexType;

    public DateIndex(String name, String currency, DateIndexType dateIndexType) {
        super(name, currency);
        this.dateIndexType = dateIndexType;
    }

    public DateIndex(String name, DateIndexType dateIndexType) {
        super(name);
        this.dateIndexType = dateIndexType;
    }

    @Override
    public RandomVariable getValue(double fixingTime, TermStructureMonteCarloSimulationModel model) throws CalculationException {
        LocalDate referenceDate = model.getModel().getForwardRateCurve().getReferenceDate().plusDays((int)Math.round(fixingTime * 365.0));
        double value = 0.0;
        switch (this.dateIndexType) {
            case DAY: {
                value = referenceDate.getDayOfMonth();
                break;
            }
            case MONTH: {
                value = referenceDate.getMonthValue();
                break;
            }
            case YEAR: {
                value = referenceDate.getYear();
                break;
            }
            case NUMBER_OF_DAYS_IN_MONTH: {
                value = referenceDate.lengthOfMonth();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown dateIndexType " + this.dateIndexType + ".");
            }
        }
        return model.getRandomVariableForConstant(value);
    }

    @Override
    public Set<String> queryUnderlyings() {
        return null;
    }

    public static enum DateIndexType {
        DAY,
        MONTH,
        YEAR,
        NUMBER_OF_DAYS_IN_MONTH;

    }
}

