/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.simple;

import java.time.LocalDateTime;
import java.util.Arrays;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.LIBORModelMonteCarloSimulationModel;
import net.finmath.montecarlo.templatemethoddesign.LogNormalProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public abstract class AbstractLIBORMarketModel
extends LogNormalProcess
implements LIBORModelMonteCarloSimulationModel {
    private final TimeDiscretization liborPeriodDiscretization;

    public AbstractLIBORMarketModel(TimeDiscretization liborPeriodDiscretization2, BrownianMotion brownianMotionLazyInit) {
        super(liborPeriodDiscretization2.getNumberOfTimeSteps(), brownianMotionLazyInit);
        this.liborPeriodDiscretization = liborPeriodDiscretization2;
    }

    @Override
    public LocalDateTime getReferenceDate() {
        throw new UnsupportedOperationException("This model does not provide a reference date. Reference dates will be mandatory in a future version.");
    }

    @Override
    public abstract Object getCloneWithModifiedSeed(int var1);

    public abstract RandomVariable getNumeraire(int var1);

    @Override
    public RandomVariable getNumeraire(double time) {
        return this.getNumeraire(this.getTimeIndex(time));
    }

    @Override
    public RandomVariable getLIBOR(int timeIndex, int liborIndex) {
        return this.getProcessValue(timeIndex, liborIndex);
    }

    @Override
    public RandomVariable[] getLIBORs(int timeIndex) {
        RandomVariable[] randomVariableVector = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            randomVariableVector[componentIndex] = this.getLIBOR(timeIndex, componentIndex);
        }
        return randomVariableVector;
    }

    @Override
    public RandomVariable getForwardRate(double time, double periodStart, double periodEnd) {
        int periodStartIndex = this.getLiborPeriodIndex(periodStart);
        int periodEndIndex = this.getLiborPeriodIndex(periodEnd);
        int timeIndex = this.getTimeIndex(time);
        if (periodStartIndex + 1 == periodEndIndex) {
            return this.getProcessValue(timeIndex, periodStartIndex);
        }
        double[] libor = new double[this.getNumberOfPaths()];
        Arrays.fill(libor, 1.0);
        for (int periodIndex = periodStartIndex; periodIndex < periodEndIndex; ++periodIndex) {
            double subPeriodLength = this.getLiborPeriod(periodIndex + 1) - this.getLiborPeriod(periodIndex);
            RandomVariable liborOverSubPeriod = this.getLIBOR(timeIndex, periodIndex);
            for (int path = 0; path < this.getNumberOfPaths(); ++path) {
                int n = path;
                libor[n] = libor[n] * (1.0 + liborOverSubPeriod.get(path) * subPeriodLength);
            }
        }
        int path = 0;
        while (path < this.getNumberOfPaths()) {
            int n = path;
            libor[n] = libor[n] - 1.0;
            int n2 = path++;
            libor[n2] = libor[n2] / (periodEnd - periodStart);
        }
        return new RandomVariableFromDoubleArray(time, libor);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public int getNumberOfLibors() {
        return this.getNumberOfComponents();
    }

    @Override
    public double getLiborPeriod(int timeIndex) {
        return this.liborPeriodDiscretization.getTime(timeIndex);
    }

    @Override
    public int getLiborPeriodIndex(double time) {
        return this.liborPeriodDiscretization.getTimeIndex(time);
    }

    @Override
    public TimeDiscretization getLiborPeriodDiscretization() {
        return this.liborPeriodDiscretization;
    }
}

