/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.simple;

import java.util.Arrays;
import java.util.Map;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.BrownianMotionFromMersenneRandomNumbers;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.models.LIBORMarketModelFromCovarianceModel;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCorrelationModel;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCorrelationModelExponentialDecay;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCovarianceModel;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCovarianceModelFromVolatilityAndCorrelation;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.montecarlo.interestrate.simple.AbstractLIBORMarketModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class SimpleLIBORMarketModel
extends AbstractLIBORMarketModel {
    private final double[] liborInitialValues;
    private LIBORCovarianceModel covarianceModel;
    private Driftapproximation driftAproximationMethod = Driftapproximation.EULER;
    private Measure measure = Measure.SPOT;

    public SimpleLIBORMarketModel(TimeDiscretization timeDiscretization, TimeDiscretization liborPeriodDiscretization, int numberOfPaths, double[] liborInitialValues, LIBORCovarianceModel covarianceModel) {
        super(liborPeriodDiscretization, (BrownianMotion)new BrownianMotionFromMersenneRandomNumbers(timeDiscretization, covarianceModel.getNumberOfFactors(), numberOfPaths, 3141));
        this.liborInitialValues = liborInitialValues;
        this.covarianceModel = covarianceModel;
    }

    public SimpleLIBORMarketModel(TimeDiscretization liborPeriodDiscretization, double[] liborInitialValues, LIBORCovarianceModel covarianceModel, BrownianMotion brownianMotion) {
        super(liborPeriodDiscretization, brownianMotion);
        if (covarianceModel.getNumberOfFactors() > brownianMotion.getNumberOfFactors()) {
            throw new RuntimeException("Number of factors in covariance model is larger than number of Brownian drivers.");
        }
        this.liborInitialValues = liborInitialValues;
        this.covarianceModel = covarianceModel;
    }

    public SimpleLIBORMarketModel(TimeDiscretization timeDiscretizationFromArray, TimeDiscretization liborPeriodDiscretization, int numberOfPaths, double[] liborInitialValues, LIBORVolatilityModel volatilityModel, LIBORCorrelationModel correlationModel) {
        super(liborPeriodDiscretization, (BrownianMotion)new BrownianMotionFromMersenneRandomNumbers(timeDiscretizationFromArray, correlationModel.getNumberOfFactors(), numberOfPaths, 3141));
        this.liborInitialValues = liborInitialValues;
        this.covarianceModel = new LIBORCovarianceModelFromVolatilityAndCorrelation(timeDiscretizationFromArray, liborPeriodDiscretization, volatilityModel, correlationModel);
    }

    public SimpleLIBORMarketModel(TimeDiscretization timeDiscretizationFromArray, TimeDiscretization liborPeriodDiscretization, int numberOfPaths, double[] liborInitialValues, LIBORVolatilityModel volatilityModel) {
        super(liborPeriodDiscretization, (BrownianMotion)new BrownianMotionFromMersenneRandomNumbers(timeDiscretizationFromArray, 1, numberOfPaths, 3141));
        this.liborInitialValues = liborInitialValues;
        this.covarianceModel = new LIBORCovarianceModelFromVolatilityAndCorrelation(timeDiscretizationFromArray, liborPeriodDiscretization, volatilityModel, new LIBORCorrelationModelExponentialDecay(timeDiscretizationFromArray, liborPeriodDiscretization, 1, 0.0, false));
    }

    @Override
    public RandomVariable[] getInitialValue() {
        RandomVariable[] initialValueRandomVariable = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            initialValueRandomVariable[componentIndex] = new RandomVariableFromDoubleArray(0.0, this.liborInitialValues[componentIndex]);
        }
        return initialValueRandomVariable;
    }

    public RandomVariableFromDoubleArray getInitialValue(int componentIndex) {
        return new RandomVariableFromDoubleArray(0.0, this.liborInitialValues[componentIndex]);
    }

    @Override
    public RandomVariable getFactorLoading(int timeIndex, int factor, int component, RandomVariable[] realizationAtTimeIndex) {
        return this.covarianceModel.getFactorLoading(timeIndex, component, (RandomVariable[])null)[factor];
    }

    @Override
    public RandomVariable[] getDrift(int timeIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        RandomVariable[] drift = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            drift[componentIndex] = this.getTime(timeIndex) >= this.getLiborPeriod(componentIndex) ? null : this.getDrift(timeIndex, componentIndex, realizationAtTimeIndex, realizationPredictor);
        }
        return drift;
    }

    @Override
    public RandomVariable getDrift(int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        int numberOfPaths = this.getNumberOfPaths();
        double time = this.getTime(timeIndex);
        RandomVariable[] liborVectorStart = realizationAtTimeIndex;
        RandomVariable[] liborVectorEnd = realizationPredictor;
        if (this.driftAproximationMethod == Driftapproximation.PREDICTOR_CORRECTOR && liborVectorEnd != null) {
            double[] drift = this.getLMMTerminasureDriftEuler(timeIndex, componentIndex, liborVectorStart);
            double[] driftEulerWithPredictor = this.getLMMTerminasureDriftEuler(timeIndex, componentIndex, liborVectorEnd);
            for (int pathIndex = 0; pathIndex < numberOfPaths; ++pathIndex) {
                drift[pathIndex] = (drift[pathIndex] + driftEulerWithPredictor[pathIndex]) / 2.0;
            }
            return new RandomVariableFromDoubleArray(time, drift);
        }
        if (this.driftAproximationMethod == Driftapproximation.LINE_INTEGRAL && liborVectorEnd != null) {
            double[] drift = this.getLMMTerminasureDriftLineIntegral(timeIndex, componentIndex, liborVectorStart, liborVectorEnd);
            return new RandomVariableFromDoubleArray(time, drift);
        }
        double[] drift = this.getLMMTerminasureDriftEuler(timeIndex, componentIndex, liborVectorStart);
        return new RandomVariableFromDoubleArray(time, drift);
    }

    public Driftapproximation getDriftAproximationMethod() {
        return this.driftAproximationMethod;
    }

    protected double[] getLMMTerminasureDriftEuler(int timeIndex, int componentIndex, RandomVariable[] liborVectorStart) {
        int numberOfPaths = this.getNumberOfPaths();
        double time = this.getTime(timeIndex);
        double[] drift = new double[numberOfPaths];
        Arrays.fill(drift, 0.0);
        int firstLiborIndex = componentIndex + 1;
        int lastLiborIndex = this.getLiborPeriodDiscretization().getNumberOfTimeSteps() - 1;
        if (this.measure == Measure.SPOT) {
            firstLiborIndex = this.getLiborPeriodIndex(time) + 1;
            if (firstLiborIndex < 0) {
                firstLiborIndex = -firstLiborIndex - 1 + 1;
            }
            lastLiborIndex = componentIndex;
        }
        for (int liborIndex = firstLiborIndex; liborIndex <= lastLiborIndex; ++liborIndex) {
            int path;
            double periodLength = this.getLiborPeriodDiscretization().getTimeStep(liborIndex);
            RandomVariable libor = liborVectorStart[liborIndex];
            RandomVariable covariance = this.covarianceModel.getCovariance(timeIndex, componentIndex, liborIndex, (RandomVariable[])null);
            if (this.measure == Measure.SPOT) {
                for (path = 0; path < drift.length; ++path) {
                    int n = path;
                    drift[n] = drift[n] + libor.get(path) * periodLength * covariance.get(path) / (1.0 + libor.get(path) * periodLength);
                }
                continue;
            }
            for (path = 0; path < drift.length; ++path) {
                int n = path;
                drift[n] = drift[n] - libor.get(path) * periodLength * covariance.get(path) / (1.0 + libor.get(path) * periodLength);
            }
        }
        return drift;
    }

    private double[] getLMMTerminasureDriftLineIntegral(int timeIndex, int componentIndex, RandomVariable[] liborVectorStart, RandomVariable[] liborVectorEnd) {
        int numberOfPaths = this.getNumberOfPaths();
        double time = this.getTime(timeIndex);
        double[] drift = new double[numberOfPaths];
        Arrays.fill(drift, 0.0);
        int firstLiborIndex = componentIndex + 1;
        int lastLiborIndex = this.getLiborPeriodDiscretization().getNumberOfTimeSteps() - 1;
        if (this.measure == Measure.SPOT) {
            firstLiborIndex = this.getLiborPeriodIndex(time) + 1;
            if (firstLiborIndex < 0) {
                firstLiborIndex = -firstLiborIndex - 1 + 1;
            }
            lastLiborIndex = componentIndex;
        }
        for (int liborIndex = firstLiborIndex; liborIndex <= lastLiborIndex; ++liborIndex) {
            double periodLength = this.getLiborPeriodDiscretization().getTimeStep(liborIndex);
            RandomVariable liborAtStartOfPeriod = liborVectorStart[liborIndex];
            RandomVariable liborAtEndOfPeriod = liborVectorEnd[liborIndex];
            RandomVariable covariance = this.covarianceModel.getCovariance(timeIndex, componentIndex, liborIndex, (RandomVariable[])null);
            for (int path = 0; path < drift.length; ++path) {
                int n = path;
                drift[n] = drift[n] - covariance.get(path) * Math.log((1.0 + periodLength * liborAtEndOfPeriod.get(path)) / (1.0 + periodLength * liborAtStartOfPeriod.get(path))) / Math.log(liborAtEndOfPeriod.get(path) / liborAtStartOfPeriod.get(path));
            }
        }
        return drift;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    @Override
    public RandomVariable getNumeraire(int timeIndex) {
        double time = this.getTime(timeIndex);
        int firstLiborIndex = this.getLiborPeriodIndex(time);
        int lastLiborIndex = this.getLiborPeriodDiscretization().getNumberOfTimeSteps() - 1;
        if (this.measure == Measure.SPOT) {
            firstLiborIndex = 0;
            lastLiborIndex = this.getLiborPeriodIndex(time) - 1;
            if (lastLiborIndex < -1) {
                System.out.println("Interpolation on Numeraire not supported.");
            }
        }
        double[] numeraire = new double[this.getNumberOfPaths()];
        Arrays.fill(numeraire, 1.0);
        for (int liborIndex = firstLiborIndex; liborIndex <= lastLiborIndex; ++liborIndex) {
            int path;
            RandomVariable libor = this.getProcessValue(Math.min(timeIndex, liborIndex), liborIndex);
            double periodLength = this.getLiborPeriodDiscretization().getTimeStep(liborIndex);
            if (this.measure == Measure.SPOT) {
                for (path = 0; path < numeraire.length; ++path) {
                    int n = path;
                    numeraire[n] = numeraire[n] * (1.0 + libor.get(path) * periodLength);
                }
                continue;
            }
            for (path = 0; path < numeraire.length; ++path) {
                int n = path;
                numeraire[n] = numeraire[n] / (1.0 + libor.get(path) * periodLength);
            }
        }
        return new RandomVariableFromDoubleArray(time, numeraire);
    }

    public void setDriftAproximationMethod(Driftapproximation driftAproximationMethod) {
        this.driftAproximationMethod = driftAproximationMethod;
    }

    public void setMeasure(Measure measure) {
        this.measure = measure;
    }

    public LIBORCovarianceModel getCovarianceModel() {
        return this.covarianceModel;
    }

    public void setCovarianceModel(LIBORCovarianceModel covarianceModel) {
        this.covarianceModel = covarianceModel;
    }

    @Override
    public SimpleLIBORMarketModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public Object getCloneWithModifiedSeed(int seed) {
        return new SimpleLIBORMarketModel(this.getLiborPeriodDiscretization(), this.liborInitialValues, this.getCovarianceModel(), new BrownianMotionFromMersenneRandomNumbers(this.getTimeDiscretization(), this.covarianceModel.getNumberOfFactors(), this.getNumberOfPaths(), seed));
    }

    @Override
    public LIBORMarketModelFromCovarianceModel getModel() {
        return null;
    }

    @Override
    public MonteCarloProcess getProcess() {
        return null;
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.getBrownianMotion().getRandomVariableForConstant(value);
    }

    @Override
    public Map<String, RandomVariable> getModelParameters() {
        throw new UnsupportedOperationException();
    }

    public static enum Driftapproximation {
        EULER,
        LINE_INTEGRAL,
        PREDICTOR_CORRECTOR;

    }

    public static enum Measure {
        SPOT,
        TERMINAL;

    }
}

