/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.interestrate.simple;

import java.util.Arrays;
import net.finmath.montecarlo.BrownianMotion;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCorrelationModel;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORCovarianceModelFromVolatilityAndCorrelation;
import net.finmath.montecarlo.interestrate.models.covariance.LIBORVolatilityModel;
import net.finmath.montecarlo.interestrate.simple.SimpleLIBORMarketModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretizationFromArray;

public class SimpleLIBORMarketModelWithWMC
extends SimpleLIBORMarketModel {
    private RandomVariable[] discreteProcessWeights;
    private final SimpleLIBORMarketModel targetScheme;

    public SimpleLIBORMarketModelWithWMC(TimeDiscretizationFromArray timeDiscretizationFromArray, TimeDiscretizationFromArray liborPeriodDiscretization, int numberOfPaths, double[] liborInitialValues, LIBORVolatilityModel volatilityModel, LIBORCorrelationModel correlationModel, SimpleLIBORMarketModel targetScheme) {
        super(timeDiscretizationFromArray, liborPeriodDiscretization, numberOfPaths, liborInitialValues, volatilityModel, correlationModel);
        this.targetScheme = targetScheme;
        this.setBrownianMotion(targetScheme.getBrownianMotion());
        this.setMeasure(targetScheme.getMeasure());
    }

    @Override
    public RandomVariable getDrift(int timeIndex, int component, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        return super.getDrift(timeIndex, component, realizationAtTimeIndex, realizationPredictor);
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) {
        if (this.discreteProcessWeights == null || this.discreteProcessWeights.length == 0) {
            this.discreteProcessWeights = new RandomVariableFromDoubleArray[this.getTimeDiscretization().getNumberOfTimeSteps() + 1];
            double changeOfNumeraire = this.getNumeraire(0).get(0) / this.targetScheme.getNumeraire(0).get(0);
            this.discreteProcessWeights[0] = new RandomVariableFromDoubleArray(0.0, 1.0 / (double)this.getNumberOfPaths() / changeOfNumeraire);
            RandomVariableFromDoubleArray[] initialValueOfTargetScheme = new RandomVariableFromDoubleArray[this.getNumberOfComponents()];
            for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                initialValueOfTargetScheme[componentIndex] = this.targetScheme.getInitialValue(componentIndex);
            }
            RandomVariable[] initialValueLogShifts = new RandomVariable[this.getNumberOfComponents()];
            for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                RandomVariableFromDoubleArray initialValueLog = this.getInitialValue(componentIndex).log();
                RandomVariableFromDoubleArray initialValueLogTarget = this.targetScheme.getInitialValue(componentIndex).log();
                initialValueLogShifts[componentIndex] = initialValueLogTarget.sub(initialValueLog);
            }
            BrownianMotion brownianMotion = this.getBrownianMotion();
            double[][] factorDrift = new double[this.getNumberOfFactors()][this.getNumberOfPaths()];
            for (int timeIndex2 = 1; timeIndex2 < this.getTimeDiscretization().getNumberOfTimeSteps() + 1; ++timeIndex2) {
                int factor;
                double deltaT = this.getTime(timeIndex2) - this.getTime(timeIndex2 - 1);
                double[] discreteProcessWeightsTimeIndex = new double[this.getNumberOfPaths()];
                for (int path = 0; path < this.getNumberOfPaths(); ++path) {
                    discreteProcessWeightsTimeIndex[path] = this.discreteProcessWeights[timeIndex2 - 1].get(path);
                }
                for (factor = 0; factor < this.getNumberOfFactors(); ++factor) {
                    Arrays.fill(factorDrift[factor], 0.0);
                }
                for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                    RandomVariable initialValueLogShift = timeIndex2 == 1 ? initialValueLogShifts[componentIndex] : null;
                    RandomVariable driftProxy = this.getDrift(timeIndex2 - 1, componentIndex, this.getProcessValue(timeIndex2 - 1), null);
                    RandomVariable driftTarget = this.targetScheme.getDrift(timeIndex2 - 1, componentIndex, timeIndex2 == 1 ? initialValueOfTargetScheme : this.getProcessValue(timeIndex2 - 1), this.getProcessValue(timeIndex2));
                    double instvol = ((LIBORCovarianceModelFromVolatilityAndCorrelation)this.getCovarianceModel()).getVolatilityModel().getVolatility(timeIndex2 - 1, componentIndex).get(0);
                    if (instvol == 0.0) {
                        System.out.println("vol zero");
                        continue;
                    }
                    for (int factor2 = 0; factor2 < this.getNumberOfFactors(); ++factor2) {
                        RandomVariable factorLoadingPseudoInverse = this.getCovarianceModel().getFactorLoadingPseudoInverse(timeIndex2 - 1, componentIndex, factor2, null);
                        for (int path = 0; path < this.getNumberOfPaths(); ++path) {
                            double[] dArray = factorDrift[factor2];
                            int n = path;
                            dArray[n] = dArray[n] + factorLoadingPseudoInverse.get(path) * ((driftTarget.get(path) - driftProxy.get(path)) * deltaT + (initialValueLogShift != null ? initialValueLogShift.get(path) : 0.0));
                        }
                    }
                }
                for (factor = 0; factor < this.getNumberOfFactors(); ++factor) {
                    RandomVariable brownianIncement = brownianMotion.getBrownianIncrement(timeIndex2 - 1, factor);
                    int path = 0;
                    while (path < this.getNumberOfPaths()) {
                        double x = brownianIncement.get(path);
                        double y = x - factorDrift[factor][path];
                        double transitionPobabilityDensityRatio = Math.exp((-y * y + x * x) / (2.0 * deltaT));
                        int n = path++;
                        discreteProcessWeightsTimeIndex[n] = discreteProcessWeightsTimeIndex[n] * transitionPobabilityDensityRatio;
                    }
                }
                this.discreteProcessWeights[timeIndex2] = new RandomVariableFromDoubleArray(this.getTime(timeIndex2), discreteProcessWeightsTimeIndex);
            }
        }
        return this.discreteProcessWeights[timeIndex];
    }
}

