/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.process;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.finmath.concurrency.FutureWrapper;
import net.finmath.montecarlo.IndependentIncrements;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.montecarlo.process.MonteCarloProcess;
import net.finmath.montecarlo.process.MonteCarloProcessFromProcessModel;
import net.finmath.stochastic.RandomVariable;

public class EulerSchemeFromProcessModel
extends MonteCarloProcessFromProcessModel {
    private static boolean isUseMultiThreadding = Boolean.parseBoolean(System.getProperty("net.finmath.montecarlo.process.EulerSchemeFromProcessModel.isUseMultiThreadding", "true"));
    private final IndependentIncrements stochasticDriver;
    private final Scheme scheme;
    private ExecutorService executor;
    private transient RandomVariable[][] discreteProcess = null;
    private transient RandomVariable[] discreteProcessWeights;

    public EulerSchemeFromProcessModel(ProcessModel model, IndependentIncrements stochasticDriver, Scheme scheme) {
        super(stochasticDriver.getTimeDiscretization(), model);
        this.stochasticDriver = stochasticDriver;
        this.scheme = scheme;
    }

    public EulerSchemeFromProcessModel(ProcessModel model, IndependentIncrements stochasticDriver) {
        super(stochasticDriver.getTimeDiscretization(), model);
        this.stochasticDriver = stochasticDriver;
        Scheme scheme = Scheme.EULER_FUNCTIONAL;
        try {
            model.applyStateSpaceTransformInverse(null, 0, 0, null);
        }
        catch (UnsupportedOperationException e) {
            scheme = Scheme.EULER;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scheme = scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable getProcessValue(int timeIndex, int componentIndex) {
        EulerSchemeFromProcessModel eulerSchemeFromProcessModel = this;
        synchronized (eulerSchemeFromProcessModel) {
            if (this.discreteProcess == null || this.discreteProcess.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        if (this.discreteProcess[timeIndex][componentIndex] == null) {
            throw new NullPointerException("Generation of process component " + componentIndex + " at time index " + timeIndex + " failed. Likely due to out of memory");
        }
        return this.discreteProcess[timeIndex][componentIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) {
        EulerSchemeFromProcessModel eulerSchemeFromProcessModel = this;
        synchronized (eulerSchemeFromProcessModel) {
            if (this.discreteProcessWeights == null || this.discreteProcessWeights.length == 0) {
                this.doPrecalculateProcess();
            }
        }
        return this.discreteProcessWeights[timeIndex];
    }

    private void doPrecalculateProcess() {
        if (this.discreteProcess != null && this.discreteProcess.length != 0) {
            return;
        }
        int numberOfPaths = this.getNumberOfPaths();
        int numberOfFactors = this.getNumberOfFactors();
        int numberOfComponents = this.getNumberOfComponents();
        this.discreteProcess = new RandomVariable[this.getTimeDiscretization().getNumberOfTimeSteps() + 1][this.getNumberOfComponents()];
        this.discreteProcessWeights = new RandomVariable[this.getTimeDiscretization().getNumberOfTimeSteps() + 1];
        this.discreteProcessWeights[0] = this.stochasticDriver.getRandomVariableForConstant(1.0 / (double)numberOfPaths);
        RandomVariable[] initialState = this.getInitialState();
        final RandomVariable[] currentState = new RandomVariable[numberOfComponents];
        for (int componentIndex = 0; componentIndex < numberOfComponents; ++componentIndex) {
            currentState[componentIndex] = initialState[componentIndex];
            this.discreteProcess[0][componentIndex] = this.applyStateSpaceTransform(0, componentIndex, currentState[componentIndex]);
        }
        this.executor = Executors.newCachedThreadPool();
        for (int timeIndex2 = 1; timeIndex2 < this.getTimeDiscretization().getNumberOfTimeSteps() + 1; ++timeIndex2) {
            RandomVariable[] drift;
            final int timeIndex = timeIndex2;
            final double deltaT = this.getTime(timeIndex) - this.getTime(timeIndex - 1);
            try {
                drift = this.getDrift(timeIndex - 1, this.discreteProcess[timeIndex - 1], null);
            }
            catch (Exception e) {
                throw new RuntimeException(e + " - drift calculaton failed at time index " + timeIndex + " (time=" + this.getTime(timeIndex - 1) + ") . See cause of this exception for details.", e);
            }
            final RandomVariable[] brownianIncrement = this.stochasticDriver.getIncrement(timeIndex - 1);
            ArrayList<Future<RandomVariable>> discreteProcessAtCurrentTimeIndex = new ArrayList<Future<RandomVariable>>(numberOfComponents);
            for (int componentIndex2 = 0; componentIndex2 < numberOfComponents; ++componentIndex2) {
                final int componentIndex = componentIndex2;
                final RandomVariable driftOfComponent = drift[componentIndex];
                if (driftOfComponent == null) {
                    discreteProcessAtCurrentTimeIndex.add(componentIndex, null);
                    continue;
                }
                Callable<RandomVariable> worker = new Callable<RandomVariable>(){

                    @Override
                    public RandomVariable call() {
                        RandomVariable[] factorLoadings;
                        if (EulerSchemeFromProcessModel.this.scheme == Scheme.EULER_FUNCTIONAL || EulerSchemeFromProcessModel.this.scheme == Scheme.PREDICTOR_CORRECTOR_FUNCTIONAL) {
                            currentState[componentIndex] = EulerSchemeFromProcessModel.this.applyStateSpaceTransformInverse(timeIndex - 1, componentIndex, EulerSchemeFromProcessModel.this.discreteProcess[timeIndex - 1][componentIndex]);
                        }
                        if ((factorLoadings = EulerSchemeFromProcessModel.this.getFactorLoading(timeIndex - 1, componentIndex, EulerSchemeFromProcessModel.this.discreteProcess[timeIndex - 1])) == null) {
                            return null;
                        }
                        if (driftOfComponent != null) {
                            currentState[componentIndex] = currentState[componentIndex].addProduct(driftOfComponent, deltaT);
                        }
                        currentState[componentIndex] = currentState[componentIndex].addSumProduct(factorLoadings, brownianIncrement);
                        return EulerSchemeFromProcessModel.this.applyStateSpaceTransform(timeIndex, componentIndex, currentState[componentIndex]);
                    }
                };
                Future<RandomVariable> result = null;
                try {
                    result = isUseMultiThreadding ? this.executor.submit(worker) : new FutureWrapper<RandomVariable>((RandomVariable)worker.call());
                }
                catch (Exception e) {
                    throw new RuntimeException("Euler step failed at time index " + timeIndex + " (time=" + this.getTime(timeIndex) + "). See cause of this exception for details.", e);
                }
                discreteProcessAtCurrentTimeIndex.add(componentIndex, result);
            }
            for (int componentIndex = 0; componentIndex < numberOfComponents; ++componentIndex) {
                try {
                    Future discreteProcessAtCurrentTimeIndexAndComponent = (Future)discreteProcessAtCurrentTimeIndex.get(componentIndex);
                    if (discreteProcessAtCurrentTimeIndexAndComponent != null) {
                        this.discreteProcess[timeIndex][componentIndex] = ((RandomVariable)discreteProcessAtCurrentTimeIndexAndComponent.get()).cache();
                        continue;
                    }
                    this.discreteProcess[timeIndex][componentIndex] = this.discreteProcess[timeIndex - 1][componentIndex];
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("Euler step failed at time index " + timeIndex + " (time=" + this.getTime(timeIndex) + "). See cause of this exception for details.", e.getCause());
                }
            }
            if (this.scheme == Scheme.PREDICTOR_CORRECTOR || this.scheme == Scheme.PREDICTOR_CORRECTOR_FUNCTIONAL) {
                RandomVariable[] driftWithPredictor = this.getDrift(timeIndex - 1, this.discreteProcess[timeIndex], null);
                for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
                    RandomVariable driftWithPredictorOfComponent = driftWithPredictor[componentIndex];
                    RandomVariable driftWithoutPredictorOfComponent = drift[componentIndex];
                    if (driftWithPredictorOfComponent == null || driftWithoutPredictorOfComponent == null) continue;
                    RandomVariable driftAdjustment = driftWithPredictorOfComponent.sub(driftWithoutPredictorOfComponent).div(2.0).mult(deltaT);
                    currentState[componentIndex] = currentState[componentIndex].add(driftAdjustment);
                    this.discreteProcess[timeIndex][componentIndex] = this.applyStateSpaceTransform(timeIndex, componentIndex, currentState[componentIndex]);
                }
            }
            this.discreteProcessWeights[timeIndex] = this.discreteProcessWeights[timeIndex - 1];
        }
        try {
            this.executor.shutdown();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public int getNumberOfPaths() {
        return this.stochasticDriver.getNumberOfPaths();
    }

    @Override
    public int getNumberOfFactors() {
        return this.stochasticDriver.getNumberOfFactors();
    }

    @Override
    public IndependentIncrements getStochasticDriver() {
        return this.stochasticDriver;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    @Override
    public EulerSchemeFromProcessModel clone() {
        return new EulerSchemeFromProcessModel(this.getModel(), this.getStochasticDriver(), this.scheme);
    }

    @Override
    public MonteCarloProcess getCloneWithModifiedModel(ProcessModel model) {
        return new EulerSchemeFromProcessModel(model, this.getStochasticDriver(), this.scheme);
    }

    @Override
    public MonteCarloProcess getCloneWithModifiedData(Map<String, Object> dataModified) {
        ProcessModel newModel = (ProcessModel)dataModified.getOrDefault("model", this.getModel());
        if (dataModified.containsKey("seed") && dataModified.containsKey("stochasticDriver")) {
            throw new IllegalArgumentException("Simultaneous specification of stochasticDriver and seed.");
        }
        IndependentIncrements newStochasticDriver = dataModified.containsKey("seed") ? this.getStochasticDriver().getCloneWithModifiedSeed((Integer)dataModified.get("seed")) : (dataModified.containsKey("stochasticDriver") ? (IndependentIncrements)dataModified.getOrDefault("stochasticDriver", this.stochasticDriver) : this.stochasticDriver);
        Scheme newScheme = (Scheme)((Object)dataModified.getOrDefault("scheme", (Object)this.scheme));
        return new EulerSchemeFromProcessModel(newModel, newStochasticDriver, newScheme);
    }

    @Override
    public Object getCloneWithModifiedSeed(int seed) {
        return new EulerSchemeFromProcessModel(this.getModel(), this.getStochasticDriver().getCloneWithModifiedSeed(seed));
    }

    public String toString() {
        return "EulerSchemeFromProcessModel [stochasticDriver=" + this.stochasticDriver + ", scheme=" + this.scheme + ", executor=" + this.executor + "]";
    }

    public static enum Scheme {
        EULER,
        PREDICTOR_CORRECTOR,
        EULER_FUNCTIONAL,
        PREDICTOR_CORRECTOR_FUNCTIONAL;

    }
}

