/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.process;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.process.Process;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;
import net.finmath.time.TimeDiscretizationFromArray;

public class LinearInterpolatedTimeDiscreteProcess
implements Process {
    private final TimeDiscretization timeDiscretization;
    private final Map<Double, RandomVariable> realizations;

    public LinearInterpolatedTimeDiscreteProcess(Map<Double, RandomVariable> realizations) {
        this.timeDiscretization = new TimeDiscretizationFromArray(realizations.keySet());
        this.realizations = new HashMap<Double, RandomVariable>();
        this.realizations.putAll(realizations);
    }

    private LinearInterpolatedTimeDiscreteProcess(TimeDiscretization timeDiscretization, Map<Double, RandomVariable> realizations) {
        this.timeDiscretization = timeDiscretization;
        this.realizations = realizations;
    }

    public LinearInterpolatedTimeDiscreteProcess add(LinearInterpolatedTimeDiscreteProcess process) throws CalculationException {
        HashMap<Double, RandomVariable> sum = new HashMap<Double, RandomVariable>();
        Iterator iterator = this.timeDiscretization.iterator();
        while (iterator.hasNext()) {
            double time = (Double)iterator.next();
            sum.put(time, this.realizations.get(time).add(process.getProcessValue(time, 0)));
        }
        return new LinearInterpolatedTimeDiscreteProcess(this.timeDiscretization, sum);
    }

    public LinearInterpolatedTimeDiscreteProcess apply(DoubleUnaryOperator function) {
        HashMap<Double, RandomVariable> result = new HashMap<Double, RandomVariable>();
        Iterator iterator = this.timeDiscretization.iterator();
        while (iterator.hasNext()) {
            double time = (Double)iterator.next();
            result.put(time, this.realizations.get(time).apply(function));
        }
        return new LinearInterpolatedTimeDiscreteProcess(this.timeDiscretization, result);
    }

    public RandomVariable getProcessValue(double time, int component) {
        double timeUpper;
        double timeLower = this.timeDiscretization.getTimeIndexNearestLessOrEqual(time);
        if (timeLower == (timeUpper = (double)this.timeDiscretization.getTimeIndexNearestGreaterOrEqual(time))) {
            return this.realizations.get(timeLower);
        }
        RandomVariable valueLower = this.realizations.get(timeLower);
        RandomVariable valueUpper = this.realizations.get(timeUpper);
        return valueUpper.mult((time - timeLower) / (timeUpper - timeLower)).add(valueLower.mult((timeUpper - time) / (timeUpper - timeLower)));
    }

    @Override
    public RandomVariable getProcessValue(int timeIndex, int component) {
        return this.realizations.get(this.timeDiscretization.getTime(timeIndex));
    }

    @Override
    public RandomVariable getMonteCarloWeights(int timeIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfComponents() {
        return 1;
    }

    @Override
    public TimeDiscretization getTimeDiscretization() {
        return this.timeDiscretization;
    }

    @Override
    public double getTime(int timeIndex) {
        return this.timeDiscretization.getTime(timeIndex);
    }

    @Override
    public int getTimeIndex(double time) {
        return this.timeDiscretization.getTimeIndex(time);
    }

    @Override
    public Process clone() {
        return new LinearInterpolatedTimeDiscreteProcess(this.timeDiscretization, this.realizations);
    }
}

