/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.process;

import net.finmath.exception.CalculationException;
import net.finmath.montecarlo.model.ProcessModel;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public interface Process {
    default public ProcessModel getModel() {
        return null;
    }

    default public RandomVariable[] getProcessValue(int timeIndex) throws CalculationException {
        RandomVariable[] processValue = new RandomVariable[this.getNumberOfComponents()];
        for (int componentIndex = 0; componentIndex < this.getNumberOfComponents(); ++componentIndex) {
            processValue[componentIndex] = this.getProcessValue(timeIndex, componentIndex);
        }
        return processValue;
    }

    public RandomVariable getProcessValue(int var1, int var2) throws CalculationException;

    public RandomVariable getMonteCarloWeights(int var1) throws CalculationException;

    public int getNumberOfComponents();

    public TimeDiscretization getTimeDiscretization();

    public double getTime(int var1);

    public int getTimeIndex(double var1);

    public Process clone();
}

