/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.montecarlo.templatemethoddesign.assetderivativevaluation;

import java.time.LocalDateTime;
import java.util.Map;
import net.finmath.montecarlo.RandomVariableFromDoubleArray;
import net.finmath.montecarlo.assetderivativevaluation.AssetModelMonteCarloSimulationModel;
import net.finmath.montecarlo.templatemethoddesign.LogNormalProcess;
import net.finmath.stochastic.RandomVariable;
import net.finmath.time.TimeDiscretization;

public class MonteCarloBlackScholesModel2
extends LogNormalProcess
implements AssetModelMonteCarloSimulationModel {
    private final double initialValue;
    private final double riskFreeRate;
    private final double volatility;
    private final RandomVariable[] initialValueVector = new RandomVariable[1];
    private final RandomVariable drift;
    private final RandomVariable volatilityOnPaths;

    public MonteCarloBlackScholesModel2(TimeDiscretization timeDiscretization, int numberOfPaths, double initialValue, double riskFreeRate, double volatility) {
        super(timeDiscretization, 1, 1, numberOfPaths, 3141);
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.initialValueVector[0] = new RandomVariableFromDoubleArray(0.0, initialValue);
        this.drift = new RandomVariableFromDoubleArray(0.0, riskFreeRate);
        this.volatilityOnPaths = new RandomVariableFromDoubleArray(0.0, volatility);
    }

    public MonteCarloBlackScholesModel2(TimeDiscretization timeDiscretization, int numberOfPaths, double initialValue, double riskFreeRate, double volatility, int seed) {
        super(timeDiscretization, 1, 1, numberOfPaths, seed);
        this.initialValue = initialValue;
        this.riskFreeRate = riskFreeRate;
        this.volatility = volatility;
        this.initialValueVector[0] = new RandomVariableFromDoubleArray(0.0, initialValue);
        this.drift = new RandomVariableFromDoubleArray(0.0, riskFreeRate);
        this.volatilityOnPaths = new RandomVariableFromDoubleArray(0.0, volatility);
    }

    @Override
    public LocalDateTime getReferenceDate() {
        throw new UnsupportedOperationException("This model does not provide a reference date. Reference dates will be mandatory in a future version.");
    }

    @Override
    public int getNumberOfAssets() {
        return 1;
    }

    @Override
    public RandomVariable[] getInitialValue() {
        return this.initialValueVector;
    }

    @Override
    public RandomVariable getDrift(int timeIndex, int componentIndex, RandomVariable[] realizationAtTimeIndex, RandomVariable[] realizationPredictor) {
        return this.drift;
    }

    @Override
    public RandomVariable getFactorLoading(int timeIndex, int factor, int component, RandomVariable[] realizationAtTimeIndex) {
        return this.volatilityOnPaths;
    }

    @Override
    public RandomVariable getAssetValue(int timeIndex, int assetIndex) {
        return this.getProcessValue(timeIndex, assetIndex);
    }

    @Override
    public RandomVariable getAssetValue(double time, int assetIndex) {
        return this.getAssetValue(this.getTimeIndex(time), assetIndex);
    }

    @Override
    public RandomVariable getMonteCarloWeights(double time) {
        return this.getMonteCarloWeights(this.getTimeIndex(time));
    }

    @Override
    public RandomVariable getNumeraire(int timeIndex) {
        double time = this.getTime(timeIndex);
        return this.getNumeraire(time);
    }

    @Override
    public RandomVariable getNumeraire(double time) {
        double numeraireValue = Math.exp(this.riskFreeRate * time);
        return new RandomVariableFromDoubleArray(time, numeraireValue);
    }

    @Override
    public RandomVariable getRandomVariableForConstant(double value) {
        return this.getBrownianMotion().getRandomVariableForConstant(value);
    }

    public String toString() {
        return super.toString() + "\nMonteCarloBlackScholesModelByInheritance:\n  initial value...:" + this.initialValue + "\n  risk free rate..:" + this.riskFreeRate + "\n  volatiliy.......:" + this.volatility;
    }

    public double getRiskFreeRate() {
        return this.riskFreeRate;
    }

    public double getVolatility() {
        return this.volatility;
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedSeed(int seed) {
        return new MonteCarloBlackScholesModel2(this.getTimeDiscretization(), this.getNumberOfPaths(), this.getInitialValue()[0].get(0), this.getRiskFreeRate(), this.getVolatility(), seed);
    }

    @Override
    public AssetModelMonteCarloSimulationModel getCloneWithModifiedData(Map<String, Object> dataModified) {
        throw new UnsupportedOperationException();
    }
}

