/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

public class GoldenSectionSearch {
    public static final double GOLDEN_SECTION_RATIO = (3.0 - Math.sqrt(5.0)) / 2.0;
    private final double[] points = new double[3];
    private final double[] values = new double[3];
    private double nextPoint;
    private boolean expectingValue = false;
    private int numberOfIterations = 0;
    private double accuracy;
    private boolean isDone = false;

    public static void main(String[] args) {
        System.out.println("Test of GoldenSectionSearch Class.\n");
        System.out.println("1. Find minimum of f(x) = (x - 0.656) * (x - 0.656):");
        GoldenSectionSearch search = new GoldenSectionSearch(-1.0, 5.0);
        while (search.getAccuracy() > 1.0E-11 && !search.isDone()) {
            double x = search.getNextPoint();
            double y = (x - 0.656) * (x - 0.656);
            search.setValue(y);
        }
        System.out.println("Result....: " + search.getBestPoint());
        System.out.println("Solution..: 0.656");
        System.out.println("Iterations: " + search.getNumberOfIterations() + "\n");
        System.out.println("2. Find minimum of f(x) = cos(x) on [0.0,6.0]:");
        GoldenSectionSearch search2 = new GoldenSectionSearch(0.0, 6.0);
        while (search2.getAccuracy() > 1.0E-11 && !search2.isDone()) {
            double x = search2.getNextPoint();
            double y = Math.cos(x);
            search2.setValue(y);
        }
        System.out.println("Result....: " + search2.getBestPoint());
        System.out.println("Solution..: 3.141592653589793 (Pi)");
        System.out.println("Iterations: " + search2.getNumberOfIterations() + "\n");
    }

    public GoldenSectionSearch(double leftPoint, double rightPoint) {
        this.points[0] = leftPoint;
        this.points[1] = GoldenSectionSearch.getGoldenSection(leftPoint, rightPoint);
        this.points[2] = rightPoint;
        this.nextPoint = this.points[0];
        this.accuracy = this.points[2] - this.points[0];
    }

    public double getBestPoint() {
        return this.points[1];
    }

    public double getNextPoint() {
        this.expectingValue = true;
        return this.nextPoint;
    }

    public void setValue(double value) {
        if (!this.expectingValue) {
            throw new RuntimeException("Call to setValue() perfomed without prior getNextPoint() call (e.g. call performed twice).");
        }
        if (this.numberOfIterations < 3) {
            this.values[this.numberOfIterations] = value;
            this.nextPoint = this.numberOfIterations < 2 ? this.points[this.numberOfIterations + 1] : (this.points[1] - this.points[0] > this.points[2] - this.points[1] ? GoldenSectionSearch.getGoldenSection(this.points[0], this.points[1]) : GoldenSectionSearch.getGoldenSection(this.points[1], this.points[2]));
        } else {
            if (this.points[1] - this.points[0] > this.points[2] - this.points[1]) {
                if (value < this.values[1]) {
                    this.points[2] = this.points[1];
                    this.values[2] = this.values[1];
                    this.points[1] = this.nextPoint;
                    this.values[1] = value;
                } else {
                    this.points[0] = this.nextPoint;
                    this.values[0] = value;
                }
            } else if (value < this.values[1]) {
                this.points[0] = this.points[1];
                this.values[0] = this.values[1];
                this.points[1] = this.nextPoint;
                this.values[1] = value;
            } else {
                this.points[2] = this.nextPoint;
                this.values[2] = value;
            }
            this.nextPoint = this.points[1] - this.points[0] > this.points[2] - this.points[1] ? GoldenSectionSearch.getGoldenSection(this.points[0], this.points[1]) : GoldenSectionSearch.getGoldenSection(this.points[1], this.points[2]);
            if (this.points[2] - this.points[0] >= this.accuracy) {
                this.isDone = true;
            }
            this.accuracy = this.points[2] - this.points[0];
        }
        ++this.numberOfIterations;
        this.expectingValue = false;
    }

    public GoldenSectionSearch optimize() {
        while (!this.isDone()) {
            double parameter = this.getNextPoint();
            double value = this.value(parameter);
            this.setValue(value);
        }
        return this;
    }

    public double value(double parameter) {
        throw new RuntimeException("Objective function not overwritten.");
    }

    public static double getGoldenSection(double left, double right) {
        return GOLDEN_SECTION_RATIO * left + (1.0 - GOLDEN_SECTION_RATIO) * right;
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public boolean isDone() {
        return this.isDone;
    }
}

