/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import net.finmath.optimizer.SolverException;
import net.finmath.optimizer.StochasticOptimizer;
import net.finmath.optimizer.StochasticOptimizerFactory;
import net.finmath.optimizer.StochasticPathwiseLevenbergMarquardtAD;
import net.finmath.stochastic.RandomVariable;

public class StochasticOptimizerFactoryPathwiseLevenbergMarquardtAD
implements StochasticOptimizerFactory {
    private final int maxIterations;
    private final RandomVariable errorTolerance;
    private final int maxThreads;

    public StochasticOptimizerFactoryPathwiseLevenbergMarquardtAD(int maxIterations, RandomVariable errorTolerance, int maxThreads) {
        this.maxIterations = maxIterations;
        this.errorTolerance = errorTolerance;
        this.maxThreads = maxThreads;
    }

    public StochasticOptimizerFactoryPathwiseLevenbergMarquardtAD(int maxIterations, int maxThreads) {
        this(maxIterations, null, maxThreads);
    }

    @Override
    public StochasticOptimizer getOptimizer(StochasticOptimizer.ObjectiveFunction objectiveFunction, RandomVariable[] initialParameters, RandomVariable[] targetValues) {
        return this.getOptimizer(objectiveFunction, initialParameters, null, null, null, targetValues);
    }

    @Override
    public StochasticOptimizer getOptimizer(StochasticOptimizer.ObjectiveFunction objectiveFunction, RandomVariable[] initialParameters, RandomVariable[] lowerBound, RandomVariable[] upperBound, RandomVariable[] targetValues) {
        return this.getOptimizer(objectiveFunction, initialParameters, lowerBound, upperBound, null, targetValues);
    }

    @Override
    public StochasticOptimizer getOptimizer(final StochasticOptimizer.ObjectiveFunction objectiveFunction, RandomVariable[] initialParameters, RandomVariable[] lowerBound, RandomVariable[] upperBound, RandomVariable[] parameterSteps, RandomVariable[] targetValues) {
        return new StochasticPathwiseLevenbergMarquardtAD(initialParameters, targetValues, null, null, this.maxIterations, this.errorTolerance, null){
            private static final long serialVersionUID = -4802903981061716810L;

            @Override
            public void setValues(RandomVariable[] parameters, RandomVariable[] values) throws SolverException {
                objectiveFunction.setValues(parameters, values);
            }
        };
    }
}

