/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer;

import net.finmath.optimizer.SolverException;
import net.finmath.optimizer.StochasticOptimizer;
import net.finmath.optimizer.StochasticOptimizerFactory;
import net.finmath.optimizer.StochasticPathwiseLevenbergMarquardt;
import net.finmath.stochastic.RandomVariable;

public class StochasticPathwiseOptimizerFactoryLevenbergMarquardt
implements StochasticOptimizerFactory {
    private final int maxIterations;
    private final double errorTolerance;
    private final int maxThreads;

    public StochasticPathwiseOptimizerFactoryLevenbergMarquardt(int maxIterations, double errorTolerance, int maxThreads) {
        this.maxIterations = maxIterations;
        this.errorTolerance = errorTolerance;
        this.maxThreads = maxThreads;
    }

    public StochasticPathwiseOptimizerFactoryLevenbergMarquardt(int maxIterations, int maxThreads) {
        this(maxIterations, 0.0, maxThreads);
    }

    @Override
    public StochasticOptimizer getOptimizer(StochasticOptimizer.ObjectiveFunction objectiveFunction, RandomVariable[] initialParameters, RandomVariable[] targetValues) {
        return this.getOptimizer(objectiveFunction, initialParameters, null, null, null, targetValues);
    }

    @Override
    public StochasticOptimizer getOptimizer(StochasticOptimizer.ObjectiveFunction objectiveFunction, RandomVariable[] initialParameters, RandomVariable[] lowerBound, RandomVariable[] upperBound, RandomVariable[] targetValues) {
        return this.getOptimizer(objectiveFunction, initialParameters, lowerBound, upperBound, null, targetValues);
    }

    @Override
    public StochasticOptimizer getOptimizer(final StochasticOptimizer.ObjectiveFunction objectiveFunction, RandomVariable[] initialParameters, RandomVariable[] lowerBound, RandomVariable[] upperBound, RandomVariable[] parameterSteps, RandomVariable[] targetValues) {
        return new StochasticPathwiseLevenbergMarquardt(initialParameters, targetValues, null, parameterSteps, this.maxIterations, null, null){
            private static final long serialVersionUID = -7050719719557572792L;

            @Override
            public void setValues(RandomVariable[] parameters, RandomVariable[] values) throws SolverException {
                objectiveFunction.setValues(parameters, values);
            }
        };
    }
}

