/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer.parameter;

import net.finmath.optimizer.parameter.ParameterTransfrom;
import net.finmath.stochastic.RandomVariable;

public class ParameterTransfromBoundedSlope
implements ParameterTransfrom {
    private final RandomVariable[] parameterLowerBound;
    private final RandomVariable[] parameterUpperBound;
    private final RandomVariable[] parameterSlopeLowerBound;
    private final RandomVariable[] parameterSlopeUpperBound;

    public ParameterTransfromBoundedSlope(RandomVariable[] parameterLowerBound, RandomVariable[] parameterUpperBound, RandomVariable[] parameterSlopeLowerBound, RandomVariable[] parameterSlopeUpperBound) {
        this.parameterLowerBound = parameterLowerBound;
        this.parameterUpperBound = parameterUpperBound;
        this.parameterSlopeLowerBound = parameterSlopeLowerBound;
        this.parameterSlopeUpperBound = parameterSlopeUpperBound;
    }

    @Override
    public RandomVariable[] getModelParametersFrom(RandomVariable[] optimizerParameters) {
        int i;
        RandomVariable[] modelParameters = new RandomVariable[optimizerParameters.length];
        for (i = 0; i < optimizerParameters.length; ++i) {
            modelParameters[i] = optimizerParameters[i].mult(-1.0).exp();
        }
        for (i = 0; i < optimizerParameters.length; ++i) {
            RandomVariable lowerBound = this.parameterLowerBound[i];
            RandomVariable upperBound = this.parameterUpperBound[i];
            if (i > 0) {
                if (this.parameterSlopeLowerBound != null) {
                    lowerBound = lowerBound.floor(modelParameters[i - 1].add(this.parameterSlopeLowerBound[i]));
                }
                if (this.parameterSlopeUpperBound != null) {
                    upperBound = upperBound.cap(modelParameters[i - 1].add(this.parameterSlopeUpperBound[i]));
                }
            }
            modelParameters[i] = modelParameters[i].mult(-1.0).exp().mult(upperBound.sub(lowerBound)).add(lowerBound);
        }
        return modelParameters;
    }

    @Override
    public RandomVariable[] getOptimizerParametersFrom(RandomVariable[] modelParameters) {
        int i;
        RandomVariable[] optimizerParameters = new RandomVariable[modelParameters.length];
        for (i = 0; i < modelParameters.length; ++i) {
            RandomVariable lowerBound = this.parameterLowerBound[i];
            RandomVariable upperBound = this.parameterUpperBound[i];
            if (i > 0) {
                if (this.parameterSlopeLowerBound != null) {
                    lowerBound = lowerBound.floor(modelParameters[i - 1].add(this.parameterSlopeLowerBound[i]));
                }
                if (this.parameterSlopeUpperBound != null) {
                    upperBound = upperBound.cap(modelParameters[i - 1].add(this.parameterSlopeUpperBound[i]));
                }
            }
            optimizerParameters[i] = modelParameters[i].sub(lowerBound).div(upperBound.sub(lowerBound)).log().mult(-1.0);
        }
        for (i = 0; i < optimizerParameters.length; ++i) {
            optimizerParameters[i] = optimizerParameters[i].log().mult(-1.0);
        }
        return optimizerParameters;
    }
}

