/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.optimizer.parameter;

import net.finmath.optimizer.parameter.ParameterTransfrom;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class ParameterTransfromSimpleBounded
implements ParameterTransfrom {
    private final RandomVariable[] parameterLowerBound;
    private final RandomVariable[] parameterUpperBound;

    public ParameterTransfromSimpleBounded(RandomVariable[] parameterLowerBound, RandomVariable[] parameterUpperBound) {
        this.parameterLowerBound = parameterLowerBound;
        this.parameterUpperBound = parameterUpperBound;
    }

    public ParameterTransfromSimpleBounded(double[] parameterLowerBound, double[] parameterUpperBound) {
        this(Scalar.arrayOf(parameterLowerBound), Scalar.arrayOf(parameterUpperBound));
    }

    @Override
    public RandomVariable[] getModelParametersFrom(RandomVariable[] optimizerParameters) {
        int i;
        RandomVariable[] parametersTransformed = new RandomVariable[optimizerParameters.length];
        for (i = 0; i < optimizerParameters.length; ++i) {
            parametersTransformed[i] = optimizerParameters[i].mult(-1.0).exp();
        }
        for (i = 1; i < optimizerParameters.length; ++i) {
        }
        for (i = 0; i < optimizerParameters.length; ++i) {
            parametersTransformed[i] = parametersTransformed[i].mult(-1.0).exp().mult(this.parameterUpperBound[i].sub(this.parameterLowerBound[i])).add(this.parameterLowerBound[i]);
        }
        return parametersTransformed;
    }

    @Override
    public RandomVariable[] getOptimizerParametersFrom(RandomVariable[] modelParameters) {
        int i;
        RandomVariable[] parameters = new RandomVariable[modelParameters.length];
        for (i = 0; i < modelParameters.length; ++i) {
            parameters[i] = modelParameters[i].sub(this.parameterLowerBound[i]).div(this.parameterUpperBound[i].sub(this.parameterLowerBound[i])).log().mult(-1.0);
        }
        for (i = parameters.length - 1; i >= 1; --i) {
        }
        for (i = 0; i < parameters.length; ++i) {
            parameters[i] = parameters[i].log().mult(-1.0);
        }
        return parameters;
    }
}

