/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.rootfinder;

import net.finmath.rootfinder.RootFinder;

public class BisectionSearch
implements RootFinder {
    private final double[] points = new double[2];
    private final double[] values = new double[2];
    private double nextPoint;
    private int numberOfIterations = 0;
    private double accuracy = Double.MAX_VALUE;
    private boolean isDone = false;

    public BisectionSearch(double leftPoint, double rightPoint) {
        this.points[0] = leftPoint;
        this.points[1] = rightPoint;
        this.nextPoint = this.points[0];
        this.accuracy = this.points[1] - this.points[0];
    }

    @Override
    public double getBestPoint() {
        return (this.points[1] + this.points[0]) / 2.0;
    }

    @Override
    public double getNextPoint() {
        return this.nextPoint;
    }

    @Override
    public void setValue(double value) {
        if (this.numberOfIterations < 2) {
            this.values[this.numberOfIterations] = value;
            this.nextPoint = this.numberOfIterations < 1 ? this.points[this.numberOfIterations + 1] : (this.points[1] + this.points[0]) / 2.0;
        } else {
            if (this.values[1] * value > 0.0) {
                this.points[1] = this.nextPoint;
                this.values[1] = value;
            } else {
                this.points[0] = this.nextPoint;
                this.values[0] = value;
            }
            this.nextPoint = (this.points[1] + this.points[0]) / 2.0;
            if (this.points[1] - this.points[0] >= this.accuracy) {
                this.isDone = true;
            }
            this.accuracy = this.points[1] - this.points[0];
        }
        ++this.numberOfIterations;
    }

    @Override
    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    @Override
    public double getAccuracy() {
        return this.accuracy;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }
}

