/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.volatilities.SwaptionDataLattice;
import net.finmath.marketdata.products.Swap;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.time.Schedule;
import net.finmath.time.SchedulePrototype;

public class Utils {
    public static SwaptionDataLattice convertTableToLattice(final DataTable table, SwaptionDataLattice.QuotingConvention quotingConvention, LocalDate referenceDate, String discountCurveName, String forwardCurveName, SchedulePrototype fixMetaSchedule, SchedulePrototype floatMetaSchedule) {
        return Utils.convertMapOfTablesToLattice((Map<Integer, DataTable>)new HashMap<Integer, DataTable>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(0, table);
            }
        }, quotingConvention, referenceDate, discountCurveName, forwardCurveName, fixMetaSchedule, floatMetaSchedule);
    }

    public static SwaptionDataLattice convertMapOfTablesToLattice(Map<Integer, DataTable> tables, SwaptionDataLattice.QuotingConvention quotingConvention, LocalDate referenceDate, String discountCurveName, String forwardCurveName, SchedulePrototype fixMetaSchedule, SchedulePrototype floatMetaSchedule) {
        ArrayList<Integer> moneynesss = new ArrayList<Integer>();
        ArrayList<Integer> maturities = new ArrayList<Integer>();
        ArrayList<Integer> tenors = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (int moneyness : tables.keySet()) {
            DataTable table = tables.get(moneyness);
            if (table.getConvention() != DataTable.TableConvention.MONTHS) {
                throw new IllegalArgumentException("This method is only set up to handle tables with convention 'inMONTHS'.");
            }
            for (int maturity : table.getMaturities()) {
                for (int termination : table.getTerminationsForMaturity(maturity)) {
                    moneynesss.add(moneyness);
                    maturities.add(maturity);
                    tenors.add(termination);
                    values.add(table.getValue(maturity, termination));
                }
            }
        }
        return new SwaptionDataLattice(referenceDate, quotingConvention, 0.0, forwardCurveName, discountCurveName, floatMetaSchedule, fixMetaSchedule, maturities.stream().mapToInt(Integer::intValue).toArray(), tenors.stream().mapToInt(Integer::intValue).toArray(), moneynesss.stream().mapToInt(Integer::intValue).toArray(), values.stream().mapToDouble(Double::doubleValue).toArray());
    }

    public static SwaptionDataLattice shiftCashToPhysicalSmile(VolatilityCubeModel model, SwaptionDataLattice physicalSwaptions, SwaptionDataLattice ... cashSwaptions) {
        SwaptionDataLattice physicalLattice = physicalSwaptions.convertLattice(SwaptionDataLattice.QuotingConvention.PAYERVOLATILITYNORMAL, model);
        for (SwaptionDataLattice cashLatticeUnconverted : cashSwaptions) {
            SwaptionDataLattice cashLattice = Utils.convertCashLatticeToNormalVolatility(cashLatticeUnconverted, model);
            ArrayList<Integer> smileMoneynesss = new ArrayList<Integer>();
            ArrayList<Integer> smileMaturities = new ArrayList<Integer>();
            ArrayList<Integer> smileTerminations = new ArrayList<Integer>();
            ArrayList<Double> smileVolatilities = new ArrayList<Double>();
            for (int moneyness : cashLattice.getMoneyness()) {
                if (moneyness == 0) continue;
                for (int maturity : cashLattice.getMaturities(moneyness)) {
                    for (int termination : cashLattice.getTenors(moneyness, maturity)) {
                        if (!cashLattice.containsEntryFor(maturity, termination, 0) || !physicalLattice.containsEntryFor(maturity, termination, 0)) continue;
                        smileMoneynesss.add(moneyness);
                        smileMaturities.add(maturity);
                        smileTerminations.add(termination);
                        smileVolatilities.add(physicalLattice.getValue(maturity, termination, 0) + cashLattice.getValue(maturity, termination, moneyness) - cashLattice.getValue(maturity, termination, 0));
                    }
                }
            }
            SwaptionDataLattice newSwaptions = new SwaptionDataLattice(cashLattice.getReferenceDate(), SwaptionDataLattice.QuotingConvention.PAYERVOLATILITYNORMAL, cashLattice.getForwardCurveName(), cashLattice.getDiscountCurveName(), cashLattice.getFloatMetaSchedule(), cashLattice.getFixMetaSchedule(), smileMaturities.stream().mapToInt(Integer::intValue).toArray(), smileTerminations.stream().mapToInt(Integer::intValue).toArray(), smileMoneynesss.stream().mapToInt(Integer::intValue).toArray(), smileVolatilities.stream().mapToDouble(Double::doubleValue).toArray());
            physicalLattice = physicalLattice.append(newSwaptions, model);
        }
        return physicalLattice;
    }

    public static SwaptionDataLattice convertCashLatticeToNormalVolatility(SwaptionDataLattice cashLattice, VolatilityCubeModel model) {
        boolean isPayer;
        SchedulePrototype fixMetaSchedule = cashLattice.getFixMetaSchedule();
        SchedulePrototype floatMetaSchedule = cashLattice.getFloatMetaSchedule();
        LocalDate referenceDate = cashLattice.getReferenceDate();
        ArrayList<Integer> maturities = new ArrayList<Integer>();
        ArrayList<Integer> tenors = new ArrayList<Integer>();
        ArrayList<Integer> moneynesss = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        if (cashLattice.getQuotingConvention() == SwaptionDataLattice.QuotingConvention.PAYERPRICE) {
            isPayer = true;
        } else if (cashLattice.getQuotingConvention() == SwaptionDataLattice.QuotingConvention.RECEIVERPRICE) {
            isPayer = false;
        } else {
            throw new IllegalArgumentException("This conversion assumes a lattice in convention PAYERPRICE or RECEIVERPRICE.");
        }
        for (int moneyness : cashLattice.getMoneyness()) {
            for (int maturity : cashLattice.getMaturities(moneyness)) {
                for (int tenor : cashLattice.getTenors(moneyness, maturity)) {
                    Schedule fixSchedule = fixMetaSchedule.generateSchedule(referenceDate, maturity, tenor);
                    Schedule floatSchedule = floatMetaSchedule.generateSchedule(referenceDate, maturity, tenor);
                    double parSwapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, model.getForwardCurve(cashLattice.getForwardCurveName()), model);
                    double strike = parSwapRate + 1.0E-4 * (double)(isPayer ? moneyness : -moneyness);
                    double cashAnnuity = Utils.cashFunction(parSwapRate, fixSchedule);
                    double optionValue = cashLattice.getValue(maturity, tenor, moneyness);
                    maturities.add(maturity);
                    tenors.add(tenor);
                    if (isPayer) {
                        moneynesss.add(moneyness);
                        values.add(AnalyticFormulas.bachelierOptionImpliedVolatility(parSwapRate, fixSchedule.getFixing(0), strike, cashAnnuity, optionValue));
                        continue;
                    }
                    moneynesss.add(-moneyness);
                    values.add(AnalyticFormulas.bachelierOptionImpliedVolatility(parSwapRate, fixSchedule.getFixing(0), strike, cashAnnuity, optionValue + 1.0E-4 * (double)moneyness * cashAnnuity));
                }
            }
        }
        return new SwaptionDataLattice(referenceDate, SwaptionDataLattice.QuotingConvention.PAYERVOLATILITYNORMAL, cashLattice.getForwardCurveName(), cashLattice.getDiscountCurveName(), floatMetaSchedule, fixMetaSchedule, maturities.stream().mapToInt(Integer::intValue).toArray(), tenors.stream().mapToInt(Integer::intValue).toArray(), moneynesss.stream().mapToInt(Integer::intValue).toArray(), values.stream().mapToDouble(Double::doubleValue).toArray());
    }

    private static double cashFunction(double swapRate, Schedule schedule) {
        int numberOfPeriods = schedule.getNumberOfPeriods();
        double periodLength = 0.0;
        for (int index = 0; index < numberOfPeriods; ++index) {
            periodLength += schedule.getPeriodLength(index);
        }
        periodLength /= (double)schedule.getNumberOfPeriods();
        if (swapRate == 0.0) {
            return (double)numberOfPeriods * periodLength;
        }
        return (1.0 - Math.pow(1.0 + periodLength * swapRate, -numberOfPeriods)) / swapRate;
    }
}

