/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.annuitymapping;

import net.finmath.marketdata.model.curves.ForwardCurve;
import net.finmath.marketdata.model.curves.ForwardCurveFromDiscountCurve;
import net.finmath.marketdata.products.Swap;
import net.finmath.singleswaprate.annuitymapping.NormalizingFunction;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.products.NormalizingDummyProduct;
import net.finmath.time.Schedule;

public class ExponentialNormalizer
implements NormalizingFunction {
    private final double initialSwapRate;
    private final double scale;

    public ExponentialNormalizer(Schedule fixSchedule, Schedule floatSchedule, String discountCurveName, String forwardCurveName, String volatilityCubeName, VolatilityCubeModel model) {
        ForwardCurveFromDiscountCurve forwardCurve = new ForwardCurveFromDiscountCurve(discountCurveName, model.getDiscountCurve(discountCurveName).getReferenceDate(), "6M");
        this.initialSwapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, (ForwardCurve)forwardCurve, model);
        NormalizingDummyProduct unscaledDummy = new NormalizingDummyProduct(fixSchedule, floatSchedule, discountCurveName, forwardCurveName, volatilityCubeName, new ExponentialNormalizer(this.initialSwapRate, 1.0));
        this.scale = 1.0 / unscaledDummy.getValue(fixSchedule.getFixing(0), model);
    }

    public ExponentialNormalizer(double initialSwapRate, double scale) {
        this.initialSwapRate = initialSwapRate;
        this.scale = scale;
    }

    @Override
    public double getValue(double swapRate) {
        double exponent = -swapRate * swapRate / this.initialSwapRate / this.initialSwapRate;
        return this.scale * Math.exp(exponent);
    }

    @Override
    public double getFirstDerivative(double swapRate) {
        double factor = -2.0 * swapRate / this.initialSwapRate / this.initialSwapRate;
        return factor * this.getValue(swapRate);
    }

    @Override
    public double getSecondDerivative(double swapRate) {
        double factor = 2.0 / this.initialSwapRate / this.initialSwapRate;
        return (factor * factor * swapRate * swapRate - factor) * this.getValue(swapRate);
    }
}

