/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.data;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import net.finmath.time.SchedulePrototype;

public interface DataTable
extends Serializable,
Cloneable {
    public static Map<String, Object> exportTable(DataTable table) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", table.getName());
        map.put("tableConvention", table.getConvention().toString());
        map.put("referenceDate", table.getReferenceDate());
        map.put("scheduleMetaData", table.getScheduleMetaData().toString());
        ArrayList<Integer> maturities = new ArrayList<Integer>();
        ArrayList<Integer> terminations = new ArrayList<Integer>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (int mat : table.getMaturities()) {
            for (int ter : table.getTerminationsForMaturity(mat)) {
                maturities.add(mat);
                terminations.add(ter);
                values.add(table.getValue(mat, ter));
            }
        }
        map.put("maturities", Collections.unmodifiableList(maturities));
        map.put("terminations", Collections.unmodifiableList(terminations));
        map.put("values", Collections.unmodifiableList(values));
        return Collections.unmodifiableMap(map);
    }

    public DataTable addPoint(int var1, int var2, double var3);

    public DataTable addPoints(int[] var1, int[] var2, double[] var3);

    public double getValue(int var1, int var2);

    public double getValue(double var1, double var3);

    public boolean containsEntryFor(int var1, int var2);

    public boolean containsEntryFor(double var1, double var3);

    public TreeSet<Integer> getMaturities();

    public TreeSet<Integer> getTerminations();

    public TreeSet<Integer> getTerminationsForMaturity(int var1);

    public TreeSet<Integer> getMaturitiesForTermination(int var1);

    public String getName();

    public TableConvention getConvention();

    public LocalDate getReferenceDate();

    public DataTable clone();

    public int size();

    public SchedulePrototype getScheduleMetaData();

    public static enum TableConvention {
        MONTHS,
        YEARS,
        DAYS,
        WEEKS;

    }
}

