/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.data;

import java.time.LocalDate;
import java.util.List;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.data.DataTableInterpolated;
import net.finmath.time.SchedulePrototype;

public class DataTableExtrapolated
extends DataTableInterpolated
implements DataTable,
Cloneable {
    private static final long serialVersionUID = 1237834784985091980L;

    public DataTableExtrapolated(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData) {
        super(name, convention, referenceDate, scheduleMetaData);
    }

    public DataTableExtrapolated(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData, int[] maturities, int[] terminations, double[] values) {
        super(name, convention, referenceDate, scheduleMetaData, maturities, terminations, values);
    }

    public DataTableExtrapolated(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData, List<Integer> maturities, List<Integer> terminations, List<Double> values) {
        super(name, convention, referenceDate, scheduleMetaData, maturities, terminations, values);
    }

    @Override
    public double getValue(int maturity, int termination) {
        int[] maturities = this.getMaturities().stream().mapToInt(Integer::intValue).toArray();
        int[] terminations = this.getTerminations().stream().mapToInt(Integer::intValue).toArray();
        int extraMat = Math.min(Math.max(maturity, maturities[0]), maturities[maturities.length - 1]);
        int extraTer = Math.min(Math.max(termination, terminations[0]), terminations[terminations.length - 1]);
        return super.getValue(extraMat, extraTer);
    }

    @Override
    public double getValue(double maturity, double termination) {
        int roundingMultiplier;
        if (this.containsEntryFor(maturity, termination)) {
            return super.getValue(maturity, termination);
        }
        switch (this.getConvention()) {
            case YEARS: {
                roundingMultiplier = 1;
                break;
            }
            case MONTHS: {
                roundingMultiplier = 12;
                break;
            }
            case DAYS: {
                roundingMultiplier = 365;
                break;
            }
            case WEEKS: {
                roundingMultiplier = 52;
                break;
            }
            default: {
                throw new RuntimeException("No tableConvention specified");
            }
        }
        int roundedMaturity = Math.toIntExact(Math.round(maturity * (double)roundingMultiplier));
        int roundedTermination = Math.toIntExact(Math.round(termination * (double)roundingMultiplier)) - roundedMaturity;
        return this.getValue(roundedMaturity, roundedTermination);
    }

    @Override
    public DataTableExtrapolated clone() {
        int[] maturities = new int[this.size()];
        int[] terminations = new int[this.size()];
        double[] values = new double[this.size()];
        int i = 0;
        for (int maturity : this.getMaturities()) {
            for (int termination : this.getTerminationsForMaturity(maturity)) {
                maturities[i] = maturity;
                terminations[i] = termination;
                values[i++] = this.getValue(maturity, termination);
            }
        }
        return new DataTableExtrapolated(this.getName(), this.getConvention(), this.getReferenceDate(), this.getScheduleMetaData(), maturities, terminations, values);
    }

    @Override
    public String toString() {
        return this.toString(1.0);
    }

    @Override
    public String toString(double unit) {
        StringBuilder builder = new StringBuilder();
        builder.append("DataTableExtrapolated with constant extrapolation and base table: ");
        builder.append(super.toString(unit));
        return builder.toString();
    }
}

