/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.data;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.data.DataTableBasic;
import net.finmath.time.SchedulePrototype;
import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.AkimaSplineInterpolator;
import org.apache.commons.math3.analysis.interpolation.BivariateGridInterpolator;
import org.apache.commons.math3.analysis.interpolation.PiecewiseBicubicSplineInterpolator;
import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;

public class DataTableInterpolated
extends DataTableBasic
implements DataTable,
Cloneable {
    private static final long serialVersionUID = -6852590286897952990L;
    private static final BivariateGridInterpolator interpolator = new PiecewiseBicubicSplineInterpolator();
    private static final UnivariateInterpolator sliceInterpolator = new AkimaSplineInterpolator();

    public static DataTableInterpolated interpolateDataTable(DataTableBasic baseTable) {
        int[] maturities = new int[baseTable.size()];
        int[] terminations = new int[baseTable.size()];
        double[] values = new double[baseTable.size()];
        int i = 0;
        for (int maturity : baseTable.getMaturities()) {
            for (int termination : baseTable.getTerminationsForMaturity(maturity)) {
                maturities[i] = maturity;
                terminations[i] = termination;
                values[i++] = baseTable.getValue(maturity, termination);
            }
        }
        return new DataTableInterpolated(baseTable.getName(), baseTable.getConvention(), baseTable.getReferenceDate(), baseTable.getScheduleMetaData(), maturities, terminations, values);
    }

    public DataTableInterpolated(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData) {
        super(name, convention, referenceDate, scheduleMetaData);
    }

    public DataTableInterpolated(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData, int[] maturities, int[] terminations, double[] values) {
        super(name, convention, referenceDate, scheduleMetaData, maturities, terminations, values);
    }

    public DataTableInterpolated(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData, List<Integer> maturities, List<Integer> terminations, List<Double> values) {
        super(name, convention, referenceDate, scheduleMetaData, maturities, terminations, values);
    }

    @Override
    public double getValue(int maturity, int termination) {
        if (this.containsEntryFor(maturity, termination)) {
            return super.getValue(maturity, termination);
        }
        if (this.getMaturities().contains(maturity)) {
            int[] terminations = this.getTerminationsForMaturity(maturity).stream().mapToInt(Integer::intValue).toArray();
            double[] values = new double[terminations.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = super.getValue(maturity, terminations[i]);
            }
            UnivariateFunction curve = sliceInterpolator.interpolate(Arrays.stream(terminations).asDoubleStream().toArray(), values);
            return curve.value((double)termination);
        }
        if (this.getTerminations().contains(termination)) {
            int[] maturities = this.getMaturitiesForTermination(termination).stream().mapToInt(Integer::intValue).toArray();
            double[] values = new double[maturities.length];
            for (int i = 0; i < maturities.length; ++i) {
                values[i] = super.getValue(maturities[i], termination);
            }
            UnivariateFunction curve = sliceInterpolator.interpolate(Arrays.stream(maturities).asDoubleStream().toArray(), values);
            return curve.value((double)maturity);
        }
        if (this.size() != this.getMaturities().size() * this.getTerminations().size()) {
            throw new RuntimeException("For interpolation " + this.getName() + " requires a regular grid of values.");
        }
        int[] maturities = this.getMaturities().stream().mapToInt(Integer::intValue).toArray();
        int[] terminations = this.getTerminations().stream().mapToInt(Integer::intValue).toArray();
        double[][] values = new double[maturities.length][terminations.length];
        for (int i = 0; i < maturities.length; ++i) {
            for (int j = 0; j < terminations.length; ++j) {
                values[i][j] = this.getValue(maturities[i], terminations[j]);
            }
        }
        BivariateFunction surface = interpolator.interpolate(Arrays.stream(maturities).asDoubleStream().toArray(), Arrays.stream(terminations).asDoubleStream().toArray(), values);
        return surface.value((double)maturity, (double)termination);
    }

    @Override
    public double getValue(double maturity, double termination) {
        int roundingMultiplier;
        if (this.containsEntryFor(maturity, termination)) {
            return super.getValue(maturity, termination);
        }
        switch (this.getConvention()) {
            case YEARS: {
                roundingMultiplier = 1;
                break;
            }
            case MONTHS: {
                roundingMultiplier = 12;
                break;
            }
            case DAYS: {
                roundingMultiplier = 365;
                break;
            }
            case WEEKS: {
                roundingMultiplier = 52;
                break;
            }
            default: {
                throw new RuntimeException("No tableConvention specified");
            }
        }
        int roundedMaturity = Math.toIntExact(Math.round(maturity * (double)roundingMultiplier));
        int roundedTermination = Math.toIntExact(Math.round(termination * (double)roundingMultiplier)) - roundedMaturity;
        return this.getValue(roundedMaturity, roundedTermination);
    }

    @Override
    public DataTableInterpolated clone() {
        int[] maturities = new int[this.size()];
        int[] terminations = new int[this.size()];
        double[] values = new double[this.size()];
        int i = 0;
        for (int maturity : this.getMaturities()) {
            for (int termination : this.getTerminationsForMaturity(maturity)) {
                maturities[i] = maturity;
                terminations[i] = termination;
                values[i++] = this.getValue(maturity, termination);
            }
        }
        return new DataTableInterpolated(this.getName(), this.getConvention(), this.getReferenceDate(), this.getScheduleMetaData(), maturities, terminations, values);
    }

    @Override
    public String toString() {
        return this.toString(1.0);
    }

    @Override
    public String toString(double unit) {
        StringBuilder builder = new StringBuilder();
        builder.append("DataTableInterpolated with interpolator " + interpolator.getClass() + " and base table: ");
        builder.append(super.toString(unit));
        return builder.toString();
    }
}

