/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.data;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import net.finmath.interpolation.BiLinearInterpolation;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.data.DataTableBasic;
import net.finmath.time.SchedulePrototype;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;

public class DataTableLinear
extends DataTableBasic
implements DataTable,
Cloneable {
    private static final long serialVersionUID = -2406767129264582719L;
    private transient BiLinearInterpolation interpolator = null;
    private static final UnivariateInterpolator sliceInterpolator = new LinearInterpolator();

    public static DataTableLinear interpolateDataTable(DataTableBasic baseTable) {
        int[] maturities = new int[baseTable.size()];
        int[] terminations = new int[baseTable.size()];
        double[] values = new double[baseTable.size()];
        int i = 0;
        for (int maturity : baseTable.getMaturities()) {
            for (int termination : baseTable.getTerminationsForMaturity(maturity)) {
                maturities[i] = maturity;
                terminations[i] = termination;
                values[i++] = baseTable.getValue(maturity, termination);
            }
        }
        return new DataTableLinear(baseTable.getName(), baseTable.getConvention(), baseTable.getReferenceDate(), baseTable.getScheduleMetaData(), maturities, terminations, values);
    }

    public DataTableLinear(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData) {
        super(name, convention, referenceDate, scheduleMetaData);
    }

    public DataTableLinear(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData, int[] maturities, int[] terminations, double[] values) {
        super(name, convention, referenceDate, scheduleMetaData, maturities, terminations, values);
    }

    public DataTableLinear(String name, DataTable.TableConvention convention, LocalDate referenceDate, SchedulePrototype scheduleMetaData, List<Integer> maturities, List<Integer> terminations, List<Double> values) {
        super(name, convention, referenceDate, scheduleMetaData, maturities, terminations, values);
    }

    private void initInterpolator() {
        if (this.interpolator != null) {
            return;
        }
        double[] maturities = this.getMaturities().stream().mapToDouble(Integer::doubleValue).toArray();
        double[] terminations = this.getTerminations().stream().mapToDouble(Integer::doubleValue).toArray();
        double[][] values = new double[maturities.length][terminations.length];
        for (int iMat = 0; iMat < maturities.length; ++iMat) {
            for (int iTer = 0; iTer < terminations.length; ++iTer) {
                values[iMat][iTer] = super.getValue((int)maturities[iMat], (int)terminations[iTer]);
            }
        }
        this.interpolator = new BiLinearInterpolation(maturities, terminations, values);
    }

    @Override
    public double getValue(int maturity, int termination) {
        if (this.containsEntryFor(maturity, termination)) {
            return super.getValue(maturity, termination);
        }
        if (this.getMaturities().size() == 1 && this.getMaturities().contains(maturity)) {
            int[] terminations = this.getTerminationsForMaturity(maturity).stream().mapToInt(Integer::intValue).toArray();
            double[] values = new double[terminations.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = super.getValue(maturity, terminations[i]);
            }
            UnivariateFunction curve = sliceInterpolator.interpolate(Arrays.stream(terminations).asDoubleStream().toArray(), values);
            return curve.value((double)termination);
        }
        if (this.getTerminations().size() == 1 && this.getTerminations().contains(termination)) {
            int[] maturities = this.getMaturitiesForTermination(termination).stream().mapToInt(Integer::intValue).toArray();
            double[] values = new double[maturities.length];
            for (int i = 0; i < maturities.length; ++i) {
                values[i] = super.getValue(maturities[i], termination);
            }
            UnivariateFunction curve = sliceInterpolator.interpolate(Arrays.stream(maturities).asDoubleStream().toArray(), values);
            return curve.value((double)maturity);
        }
        if (this.size() != this.getMaturities().size() * this.getTerminations().size()) {
            throw new RuntimeException("For interpolation " + this.getName() + " requires a regular grid of values.");
        }
        this.initInterpolator();
        return this.interpolator.apply(new Double(maturity), new Double(termination));
    }

    @Override
    public double getValue(double maturity, double termination) {
        int roundingMultiplier;
        if (this.containsEntryFor(maturity, termination)) {
            return super.getValue(maturity, termination);
        }
        switch (this.getConvention()) {
            case YEARS: {
                roundingMultiplier = 1;
                break;
            }
            case MONTHS: {
                roundingMultiplier = 12;
                break;
            }
            case DAYS: {
                roundingMultiplier = 365;
                break;
            }
            case WEEKS: {
                roundingMultiplier = 52;
                break;
            }
            default: {
                throw new RuntimeException("No tableConvention specified");
            }
        }
        int roundedMaturity = Math.toIntExact(Math.round(maturity * (double)roundingMultiplier));
        int roundedTermination = Math.toIntExact(Math.round(termination * (double)roundingMultiplier)) - roundedMaturity;
        return this.getValue(roundedMaturity, roundedTermination);
    }

    @Override
    public DataTableLinear clone() {
        int[] maturities = new int[this.size()];
        int[] terminations = new int[this.size()];
        double[] values = new double[this.size()];
        int i = 0;
        for (int maturity : this.getMaturities()) {
            for (int termination : this.getTerminationsForMaturity(maturity)) {
                maturities[i] = maturity;
                terminations[i] = termination;
                values[i++] = this.getValue(maturity, termination);
            }
        }
        return new DataTableLinear(this.getName(), this.getConvention(), this.getReferenceDate(), this.getScheduleMetaData(), maturities, terminations, values);
    }

    @Override
    public String toString() {
        return this.toString(1.0);
    }

    @Override
    public String toString(double unit) {
        StringBuilder builder = new StringBuilder();
        builder.append("DataTableLinear with base table: ");
        builder.append(super.toString(unit));
        return builder.toString();
    }
}

