/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.data;

import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.volatilities.SwaptionDataLattice;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.marketdata.products.Swap;
import net.finmath.marketdata.products.SwapAnnuity;
import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.products.CashSettledPayerSwaption;
import net.finmath.singleswaprate.products.CashSettledReceiverSwaption;
import net.finmath.time.Schedule;
import net.finmath.time.SchedulePrototype;

public class ErrorEstimation {
    private final LocalDate referenceDate;
    private final SchedulePrototype fixMetaSchedule;
    private final SchedulePrototype floatMetaSchedule;
    private final AnnuityMapping.AnnuityMappingType annuityMappingType;
    private final String discountCurveName;
    private final String forwardCurveName;
    private final String volatilityCubeName;
    private final double replicationLowerBound;
    private final double replicationUpperBound;
    private final int replicationNumberOfEvaluationPoints;
    private final SwaptionDataLattice physicalPremiumsATM;
    private final SwaptionDataLattice cashPayerPremiums;
    private final SwaptionDataLattice cashReceiverPremiums;
    private double[] marketCash;
    private double[] marketPhysical;
    private double[] modelCash;
    private double[] modelPhysical;
    private double[] marketCashTenor;
    private double[] modelCashTenor;
    private int evaluatedMaturity;
    private int evaluatedTermination;

    public ErrorEstimation(LocalDate referenceDate, SchedulePrototype fixMetaSchedule, SchedulePrototype floatMetaSchedule, AnnuityMapping.AnnuityMappingType annuityMappingType, SwaptionDataLattice physicalPremiumsATM, SwaptionDataLattice cashPayerPremiums, SwaptionDataLattice cashReceiverPremiums, String discountCurveName, String forwardCurveName, String volatilityCubeName, double replicationLowerBound, double replicationUpperBound, int replicationNumberOfEvaluationPoints) throws IOException {
        this.referenceDate = referenceDate;
        this.fixMetaSchedule = fixMetaSchedule;
        this.floatMetaSchedule = floatMetaSchedule;
        this.annuityMappingType = annuityMappingType;
        this.discountCurveName = discountCurveName;
        this.forwardCurveName = forwardCurveName;
        this.volatilityCubeName = volatilityCubeName;
        this.replicationLowerBound = replicationLowerBound;
        this.replicationUpperBound = replicationUpperBound;
        this.replicationNumberOfEvaluationPoints = replicationNumberOfEvaluationPoints;
        this.physicalPremiumsATM = physicalPremiumsATM;
        this.cashPayerPremiums = cashPayerPremiums;
        this.cashReceiverPremiums = cashReceiverPremiums;
    }

    public void evaluate(SwaptionDataLattice nodes, VolatilityCubeModel model) {
        if (nodes == null) {
            nodes = this.physicalPremiumsATM.append(this.cashPayerPremiums, model).append(this.cashReceiverPremiums, model);
        }
        ArrayList<Double> marketPhysicalList = new ArrayList<Double>();
        ArrayList<Double> modelPhysicalList = new ArrayList<Double>();
        ArrayList<Double> marketCashPayer = new ArrayList<Double>();
        ArrayList<Double> marketCashReceiver = new ArrayList<Double>();
        ArrayList<Double> modelCashPayer = new ArrayList<Double>();
        ArrayList<Double> modelCashReceiver = new ArrayList<Double>();
        for (int maturity : nodes.getMaturities()) {
            for (int termination : nodes.getTenors()) {
                Schedule fixSchedule = this.fixMetaSchedule.generateSchedule(this.referenceDate, maturity, termination);
                Schedule floatSchedule = this.floatMetaSchedule.generateSchedule(this.referenceDate, maturity, termination);
                double optionMaturity = fixSchedule.getFixing(0);
                double swapMaturity = fixSchedule.getPayment(fixSchedule.getNumberOfPeriods() - 1);
                double annuity = SwapAnnuity.getSwapAnnuity(optionMaturity, fixSchedule, model.getDiscountCurve(this.discountCurveName), model);
                double swapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, model.getForwardCurve(this.forwardCurveName), model);
                double volatility = model.getVolatilityCube(this.volatilityCubeName).getValue(model, swapMaturity, optionMaturity, swapRate, VolatilitySurface.QuotingConvention.VOLATILITYNORMAL);
                marketPhysicalList.add(this.physicalPremiumsATM.getValue(0, maturity, termination));
                modelPhysicalList.add(AnalyticFormulas.bachelierOptionValue(swapRate, volatility, optionMaturity, swapRate, annuity));
                for (int moneyness : this.cashPayerPremiums.getMoneyness()) {
                    if (this.cashPayerPremiums.containsEntryFor(maturity, termination, moneyness)) {
                        double payerStrike = swapRate + (double)moneyness / 10000.0;
                        CashSettledPayerSwaption payer = new CashSettledPayerSwaption(fixSchedule, floatSchedule, payerStrike, this.discountCurveName, this.forwardCurveName, this.volatilityCubeName, this.annuityMappingType, this.replicationLowerBound, this.replicationUpperBound, this.replicationNumberOfEvaluationPoints);
                        marketCashPayer.add(this.cashPayerPremiums.getValue(maturity, termination, moneyness));
                        modelCashPayer.add(payer.getValue(optionMaturity, model));
                    }
                    if (!this.cashReceiverPremiums.containsEntryFor(maturity, termination, moneyness)) continue;
                    double receiverStrike = swapRate - (double)moneyness / 10000.0;
                    CashSettledReceiverSwaption receiver = new CashSettledReceiverSwaption(fixSchedule, floatSchedule, receiverStrike, this.discountCurveName, this.forwardCurveName, this.volatilityCubeName, this.annuityMappingType, this.replicationLowerBound, this.replicationUpperBound, this.replicationNumberOfEvaluationPoints);
                    marketCashReceiver.add(this.cashReceiverPremiums.getValue(maturity, termination, moneyness));
                    modelCashReceiver.add(receiver.getValue(optionMaturity, model));
                }
            }
        }
        this.marketPhysical = marketPhysicalList.stream().mapToDouble(Double::doubleValue).toArray();
        this.modelPhysical = modelPhysicalList.stream().mapToDouble(Double::doubleValue).toArray();
        marketCashPayer.addAll(marketCashReceiver);
        modelCashPayer.addAll(modelCashReceiver);
        this.marketCash = marketCashPayer.stream().mapToDouble(Double::doubleValue).toArray();
        this.modelCash = modelCashPayer.stream().mapToDouble(Double::doubleValue).toArray();
    }

    private void evaluateTenor(int maturity, int termination, VolatilityCubeModel model) {
        ArrayList<Double> marketCashPayer = new ArrayList<Double>();
        ArrayList<Double> marketCashReceiver = new ArrayList<Double>();
        ArrayList<Double> modelCashPayer = new ArrayList<Double>();
        ArrayList<Double> modelCashReceiver = new ArrayList<Double>();
        Schedule fixSchedule = this.fixMetaSchedule.generateSchedule(this.referenceDate, maturity, termination);
        Schedule floatSchedule = this.floatMetaSchedule.generateSchedule(this.referenceDate, maturity, termination);
        double optionMaturity = fixSchedule.getFixing(0);
        double swapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, model.getForwardCurve(this.forwardCurveName), model);
        for (int moneyness : this.cashPayerPremiums.getMoneyness()) {
            if (!this.cashPayerPremiums.containsEntryFor(maturity, termination, moneyness)) continue;
            double payerStrike = swapRate + (double)moneyness / 10000.0;
            CashSettledPayerSwaption payer = new CashSettledPayerSwaption(fixSchedule, floatSchedule, payerStrike, this.discountCurveName, this.forwardCurveName, this.volatilityCubeName, this.annuityMappingType, this.replicationLowerBound, this.replicationUpperBound, this.replicationNumberOfEvaluationPoints);
            marketCashPayer.add(this.cashPayerPremiums.getValue(maturity, termination, moneyness));
            modelCashPayer.add(payer.getValue(optionMaturity, model));
        }
        for (int moneyness : this.cashReceiverPremiums.getMoneyness()) {
            if (!this.cashReceiverPremiums.containsEntryFor(maturity, termination, moneyness)) continue;
            double receiverStrike = swapRate - (double)moneyness / 10000.0;
            CashSettledReceiverSwaption receiver = new CashSettledReceiverSwaption(fixSchedule, floatSchedule, receiverStrike, this.discountCurveName, this.forwardCurveName, this.volatilityCubeName, this.annuityMappingType, this.replicationLowerBound, this.replicationUpperBound, this.replicationNumberOfEvaluationPoints);
            marketCashReceiver.add(this.cashReceiverPremiums.getValue(maturity, termination, moneyness));
            modelCashReceiver.add(receiver.getValue(optionMaturity, model));
        }
        marketCashPayer.addAll(marketCashReceiver);
        modelCashPayer.addAll(modelCashReceiver);
        this.marketCashTenor = marketCashPayer.stream().mapToDouble(Double::doubleValue).toArray();
        this.modelCashTenor = modelCashPayer.stream().mapToDouble(Double::doubleValue).toArray();
        this.evaluatedMaturity = maturity;
        this.evaluatedTermination = termination;
    }

    public double getCashAverageError() {
        double sum = 0.0;
        double c = 0.0;
        for (int i = 0; i < this.marketCash.length; ++i) {
            double y = Math.abs(this.marketCash[i] - this.modelCash[i]) - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
        }
        return sum / (double)this.marketCash.length;
    }

    public double getCashMaxError() {
        double max = 0.0;
        for (int i = 0; i < this.marketCash.length; ++i) {
            max = Math.max(max, Math.abs(this.marketCash[i] - this.modelCash[i]));
        }
        return max;
    }

    public double getCashAverageErrorPercent() {
        double sum = 0.0;
        double c = 0.0;
        for (int i = 0; i < this.marketCash.length; ++i) {
            double y = Math.abs(this.modelCash[i] / this.marketCash[i] - 1.0) - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
        }
        return sum / (double)this.marketCash.length;
    }

    public double getCashMaxErrorPercent() {
        double max = 0.0;
        for (int i = 0; i < this.marketCash.length; ++i) {
            max = Math.max(max, Math.abs(this.modelCash[i] / this.marketCash[i] - 1.0));
        }
        return max;
    }

    public double getPhysicalAverageError() {
        double sum = 0.0;
        double c = 0.0;
        for (int i = 0; i < this.marketPhysical.length; ++i) {
            double y = Math.abs(this.marketPhysical[i] - this.modelPhysical[i]) - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
        }
        return sum / (double)this.marketPhysical.length;
    }

    public double getPhysicalMaxError() {
        double max = 0.0;
        for (int i = 0; i < this.marketPhysical.length; ++i) {
            max = Math.max(max, Math.abs(this.marketPhysical[i] - this.modelPhysical[i]));
        }
        return max;
    }

    public double getPhysicalAverageErrorPercent() {
        double sum = 0.0;
        double c = 0.0;
        for (int i = 0; i < this.marketPhysical.length; ++i) {
            double y = Math.abs(this.modelPhysical[i] / this.marketPhysical[i] - 1.0) - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
        }
        return sum / (double)this.marketPhysical.length;
    }

    public double getPhysicalMaxErrorPercent() {
        double max = 0.0;
        for (int i = 0; i < this.marketPhysical.length; ++i) {
            max = Math.max(max, Math.abs(this.modelPhysical[i] / this.marketPhysical[i] - 1.0));
        }
        return max;
    }

    public double getCashAverageError(int maturity, int termination, VolatilityCubeModel model) {
        if (maturity != this.evaluatedMaturity || termination != this.evaluatedTermination) {
            this.evaluateTenor(maturity, termination, model);
        }
        double sum = 0.0;
        double c = 0.0;
        for (int i = 0; i < this.marketCashTenor.length; ++i) {
            double y = Math.abs(this.marketCashTenor[i] - this.modelCashTenor[i]) - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
        }
        return sum / (double)this.marketCashTenor.length;
    }

    public double getCashMaxError(int maturity, int termination, VolatilityCubeModel model) {
        if (maturity != this.evaluatedMaturity || termination != this.evaluatedTermination) {
            this.evaluateTenor(maturity, termination, model);
        }
        double max = 0.0;
        for (int i = 0; i < this.marketCashTenor.length; ++i) {
            max = Math.max(max, Math.abs(this.marketCashTenor[i] - this.modelCashTenor[i]));
        }
        return max;
    }

    public double getCashAverageErrorPercent(int maturity, int termination, VolatilityCubeModel model) {
        if (maturity != this.evaluatedMaturity || termination != this.evaluatedTermination) {
            this.evaluateTenor(maturity, termination, model);
        }
        double sum = 0.0;
        double c = 0.0;
        for (int i = 0; i < this.marketCashTenor.length; ++i) {
            double y = Math.abs(this.modelCashTenor[i] / this.marketCashTenor[i] - 1.0) - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
        }
        return sum / (double)this.marketCashTenor.length;
    }

    public double getCashMaxErrorPercent(int maturity, int termination, VolatilityCubeModel model) {
        if (maturity != this.evaluatedMaturity || termination != this.evaluatedTermination) {
            this.evaluateTenor(maturity, termination, model);
        }
        double max = 0.0;
        for (int i = 0; i < this.marketCashTenor.length; ++i) {
            max = Math.max(max, Math.abs(this.modelCashTenor[i] / this.marketCashTenor[i] - 1.0));
        }
        return max;
    }
}

