/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.model.curves;

import java.time.LocalDate;
import net.finmath.marketdata.model.AnalyticModel;
import net.finmath.marketdata.model.curves.AbstractCurve;
import net.finmath.marketdata.model.curves.CurveBuilder;

public class ExponentialCorrelationCurve
extends AbstractCurve
implements Cloneable {
    private static final long serialVersionUID = -2781643232961198556L;
    private final double termination;
    private final double correlationDecay;

    public ExponentialCorrelationCurve(String name, LocalDate referenceDate, double termination, double correlationDecay) {
        super(name, referenceDate);
        this.termination = termination;
        this.correlationDecay = correlationDecay;
    }

    @Override
    public double getValue(AnalyticModel model, double time) {
        if (time > this.termination) {
            return 1.0;
        }
        return Math.exp(this.correlationDecay * (time - this.termination));
    }

    @Override
    public CurveBuilder getCloneBuilder() {
        throw new UnsupportedOperationException("This class does not allow to add points.");
    }

    @Override
    public double[] getParameter() {
        return new double[]{this.termination, this.correlationDecay};
    }

    @Override
    public void setParameter(double[] parameter) {
        throw new UnsupportedOperationException("This class is immutable.");
    }
}

