/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.model.volatilities;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;

public class SABRVolatilityCube
implements VolatilityCube,
Serializable {
    private static final long serialVersionUID = -3359125061963953634L;
    private final String name;
    private final LocalDate referenceDate;
    private final DataTable underlyingTable;
    private final double sabrDisplacement;
    private final double sabrBeta;
    private final DataTable rhoTable;
    private final DataTable baseVolTable;
    private final DataTable volvolTable;
    private final double iborOisDecorrelation;
    private final double correlationDecay;
    private final VolatilitySurface.QuotingConvention quotingConvention = VolatilitySurface.QuotingConvention.VOLATILITYNORMAL;

    public SABRVolatilityCube(String name, LocalDate referenceDate, DataTable swapRateTable, double sabrDisplacement, double sabrBeta, DataTable rhoTable, DataTable baseVolTable, DataTable volvolTable, double correlationDecay) {
        this(name, referenceDate, swapRateTable, sabrDisplacement, sabrBeta, rhoTable, baseVolTable, volvolTable, correlationDecay, 1.0);
    }

    public SABRVolatilityCube(String name, LocalDate referenceDate, DataTable swapRateTable, double sabrDisplacement, double sabrBeta, DataTable rhoTable, DataTable baseVolTable, DataTable volvolTable, double correlationDecay, double iborOisDecorrelation) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.underlyingTable = swapRateTable;
        this.sabrDisplacement = sabrDisplacement;
        this.sabrBeta = sabrBeta;
        this.rhoTable = rhoTable;
        this.baseVolTable = baseVolTable;
        this.volvolTable = volvolTable;
        this.correlationDecay = correlationDecay;
        this.iborOisDecorrelation = iborOisDecorrelation;
    }

    @Override
    public double getValue(VolatilityCubeModel model, double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        if (termination < maturity) {
            throw new IllegalArgumentException("Termination has to be larger (or equal) maturity. Was termination=" + termination + ", maturity=" + maturity);
        }
        if (quotingConvention != this.quotingConvention) {
            throw new IllegalArgumentException("This cube supports only the Quoting Convention " + this.quotingConvention);
        }
        double underlying = this.underlyingTable.getValue(maturity, termination);
        double sabrRho = this.rhoTable.getValue(maturity, termination);
        double baseVol = this.baseVolTable.getValue(maturity, termination);
        double sabrVolvol = this.volvolTable.getValue(maturity, termination);
        return AnalyticFormulas.sabrBerestyckiNormalVolatilityApproximation(baseVol, this.sabrBeta, sabrRho, sabrVolvol, this.sabrDisplacement, underlying, strike, maturity);
    }

    @Override
    public double getValue(double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.getValue(null, termination, maturity, strike, quotingConvention);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public double getCorrelationDecay() {
        return this.correlationDecay;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sabrBeta", this.sabrBeta);
        map.put("sabrDisplacement", this.sabrDisplacement);
        map.put("underlyingTable", this.underlyingTable.clone());
        map.put("baseVolTable", this.baseVolTable.clone());
        map.put("volvolTable", this.volvolTable.clone());
        map.put("rhoTable", this.rhoTable.clone());
        map.put("Inherent correlationDecay", this.correlationDecay);
        map.put("iborOisDecorrelation", this.iborOisDecorrelation);
        return map;
    }

    @Override
    public double getLowestStrike(VolatilityCubeModel model) {
        return -this.sabrDisplacement;
    }

    @Override
    public double getIborOisDecorrelation() {
        return this.iborOisDecorrelation;
    }

    public DataTable getUnderlyingTable() {
        return this.underlyingTable.clone();
    }

    public DataTable getRhoTable() {
        return this.rhoTable.clone();
    }

    public DataTable getBaseVolTable() {
        return this.baseVolTable.clone();
    }

    public DataTable getVolvolTable() {
        return this.volvolTable.clone();
    }
}

