/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.model.volatilities;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import net.finmath.functions.AnalyticFormulas;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;

public class SABRVolatilityCubeParallel
implements VolatilityCube,
Serializable {
    private static final long serialVersionUID = 4210804671265036606L;
    private final String name;
    private final LocalDate referenceDate;
    private final DataTable underlyingTable;
    private final double iborOisDecorrelation;
    private final double sabrDisplacement;
    private final double sabrBeta;
    private final double sabrRho;
    private final double sabrVolvol;
    private final DataTable baseVolTable;
    private final double correlationDecay;
    private final VolatilitySurface.QuotingConvention quotingConvention = VolatilitySurface.QuotingConvention.VOLATILITYNORMAL;

    public SABRVolatilityCubeParallel(String name, LocalDate referenceDate, DataTable swapRateTable, double sabrDisplacement, double sabrBeta, double sabrRho, double sabrVolvol, DataTable baseVolTable, double correlationDecay) {
        this(name, referenceDate, swapRateTable, sabrDisplacement, sabrBeta, sabrRho, sabrVolvol, baseVolTable, correlationDecay, 1.0);
    }

    public SABRVolatilityCubeParallel(String name, LocalDate referenceDate, DataTable swapRateTable, double sabrDisplacement, double sabrBeta, double sabrRho, double sabrVolvol, DataTable baseVolTable, double correlationDecay, double iborOisDecorrelation) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.underlyingTable = swapRateTable;
        this.sabrBeta = sabrBeta;
        this.sabrRho = sabrRho;
        this.sabrVolvol = sabrVolvol;
        this.sabrDisplacement = sabrDisplacement;
        this.correlationDecay = correlationDecay;
        this.baseVolTable = baseVolTable;
        this.iborOisDecorrelation = iborOisDecorrelation;
    }

    @Override
    public double getValue(VolatilityCubeModel model, double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        if (termination < maturity) {
            throw new IllegalArgumentException("Termination has to be larger (or equal) maturity. Was termination=" + termination + ", maturity=" + maturity);
        }
        if (quotingConvention != this.quotingConvention) {
            throw new IllegalArgumentException("This cube supports only the Quoting Convention " + this.quotingConvention);
        }
        double underlying = this.underlyingTable.getValue(maturity, termination);
        double baseVol = this.baseVolTable.getValue(maturity, termination);
        return AnalyticFormulas.sabrBerestyckiNormalVolatilityApproximation(baseVol, this.sabrBeta, this.sabrRho, this.sabrVolvol, this.sabrDisplacement, underlying, strike, maturity);
    }

    @Override
    public double getValue(double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.getValue(null, termination, maturity, strike, quotingConvention);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public double getCorrelationDecay() {
        return this.correlationDecay;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sabrBeta", this.sabrBeta);
        map.put("sabrRho", this.sabrRho);
        map.put("sabrVolvol", this.sabrVolvol);
        map.put("sabrDisplacement", this.sabrDisplacement);
        map.put("underlyingTable", this.underlyingTable.clone());
        map.put("baseVolTable", this.baseVolTable.clone());
        map.put("Inherent correlationDecay", this.correlationDecay);
        map.put("iborOisDecorrelation", this.iborOisDecorrelation);
        return map;
    }

    @Override
    public double getLowestStrike(VolatilityCubeModel model) {
        return -this.sabrDisplacement;
    }

    @Override
    public double getIborOisDecorrelation() {
        return this.iborOisDecorrelation;
    }
}

