/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.model.volatilities;

import java.time.LocalDate;
import java.util.ArrayList;
import net.finmath.marketdata.model.volatilities.SwaptionDataLattice;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.marketdata.products.Swap;
import net.finmath.singleswaprate.data.DataTable;
import net.finmath.singleswaprate.data.DataTableInterpolated;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.SABRVolatilityCubeParallel;
import net.finmath.time.Schedule;
import net.finmath.time.SchedulePrototype;

public class SABRVolatilityCubeParallelFactory {
    private final String cubeName;
    private final LocalDate referenceDate;
    private final SchedulePrototype floatMetaSchedule;
    private final SchedulePrototype fixMetaSchedule;
    private final double sabrBeta;
    private final double sabrDisplacement;
    private final double sabrRho;
    private final double sabrVolvol;
    private final double correlationDecay;
    private final double iborOisDecorrelation;
    private final VolatilityCubeModel model;
    private final String forwardCurveName;
    private DataTable baseVolTable;
    private DataTable swapRateTable;
    private final SwaptionDataLattice physicalATMSwaptionsVolatilities;

    public static SABRVolatilityCubeParallel createSABRVolatilityCubeParallel(String cubeName, LocalDate referenceDate, SchedulePrototype fixMetaSchedule, SchedulePrototype floatMetaSchedule, double sabrDisplacement, double sabrBeta, double sabrRho, double sabrVolvol, double correlationDecay, double iborOisDecorrelation, SwaptionDataLattice physicalATMSwaptions, VolatilityCubeModel model, String forwardCurveName) {
        SABRVolatilityCubeParallelFactory factory = new SABRVolatilityCubeParallelFactory(cubeName, referenceDate, fixMetaSchedule, floatMetaSchedule, sabrDisplacement, sabrBeta, sabrRho, sabrVolvol, correlationDecay, iborOisDecorrelation, physicalATMSwaptions.convertLattice(SwaptionDataLattice.QuotingConvention.PAYERVOLATILITYNORMAL, model), model, forwardCurveName);
        return factory.buildParallel();
    }

    private SABRVolatilityCubeParallelFactory(String cubeName, LocalDate referenceDate, SchedulePrototype fixMetaSchedule, SchedulePrototype floatMetaSchedule, double sabrDisplacement, double sabrBeta, double sabrRho, double sabrVolvol, double correlationDecay, double iborOisDecorrelation, SwaptionDataLattice physicalATMSwaptionVolatilities, VolatilityCubeModel model, String forwardCurveName) {
        this.cubeName = cubeName;
        this.referenceDate = referenceDate;
        this.fixMetaSchedule = fixMetaSchedule;
        this.floatMetaSchedule = floatMetaSchedule;
        this.sabrBeta = sabrBeta;
        this.sabrDisplacement = sabrDisplacement;
        this.sabrRho = sabrRho;
        this.sabrVolvol = sabrVolvol;
        this.correlationDecay = correlationDecay;
        this.iborOisDecorrelation = iborOisDecorrelation;
        this.physicalATMSwaptionsVolatilities = physicalATMSwaptionVolatilities;
        this.model = model;
        this.forwardCurveName = forwardCurveName;
    }

    private SABRVolatilityCubeParallel buildParallel() {
        this.swapRateTable = this.makeSwapRateTable();
        this.baseVolTable = this.makeBaseVolTable();
        return new SABRVolatilityCubeParallel(this.cubeName, this.referenceDate, this.swapRateTable, this.sabrDisplacement, this.sabrBeta, this.sabrRho, this.sabrVolvol, this.baseVolTable, this.correlationDecay, this.iborOisDecorrelation);
    }

    private DataTable makeSwapRateTable() {
        ArrayList<Integer> maturitiesList = new ArrayList<Integer>();
        ArrayList<Integer> terminationsList = new ArrayList<Integer>();
        ArrayList<Double> swapRateList = new ArrayList<Double>();
        for (int maturity : this.physicalATMSwaptionsVolatilities.getMaturities(0)) {
            for (int termination : this.physicalATMSwaptionsVolatilities.getTenors(0, maturity)) {
                maturitiesList.add(maturity);
                terminationsList.add(termination);
                LocalDate maturityDate = this.referenceDate.plusMonths(maturity);
                LocalDate terminationDate = maturityDate.plusMonths(termination);
                Schedule floatSchedule = this.floatMetaSchedule.generateSchedule(this.referenceDate, maturityDate, terminationDate);
                Schedule fixSchedule = this.fixMetaSchedule.generateSchedule(this.referenceDate, maturityDate, terminationDate);
                double swapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, this.model.getForwardCurve(this.forwardCurveName), this.model);
                swapRateList.add(swapRate);
            }
        }
        return new DataTableInterpolated("Swap Rates", DataTable.TableConvention.MONTHS, this.referenceDate, this.floatMetaSchedule, maturitiesList, terminationsList, swapRateList);
    }

    private DataTable makeBaseVolTable() {
        int[] maturitiesArray = new int[this.swapRateTable.size()];
        int[] terminationsArray = new int[this.swapRateTable.size()];
        double[] valuesArray = new double[this.swapRateTable.size()];
        int index = 0;
        for (int maturity : this.swapRateTable.getMaturities()) {
            for (int termination : this.swapRateTable.getTerminationsForMaturity(maturity)) {
                maturitiesArray[index] = maturity;
                terminationsArray[index] = termination;
                valuesArray[index++] = 0.01;
            }
        }
        DataTableInterpolated tempTable = new DataTableInterpolated("Temp Volatilities", DataTable.TableConvention.MONTHS, this.referenceDate, this.floatMetaSchedule, maturitiesArray, terminationsArray, valuesArray);
        SABRVolatilityCubeParallel tempCube = new SABRVolatilityCubeParallel("tempCube", this.referenceDate, this.swapRateTable, this.sabrDisplacement, this.sabrBeta, this.sabrRho, this.sabrVolvol, tempTable, this.correlationDecay, this.iborOisDecorrelation);
        index = 0;
        for (int maturity : this.swapRateTable.getMaturities()) {
            for (int termination : this.swapRateTable.getTerminationsForMaturity(maturity)) {
                LocalDate maturityDate = this.referenceDate.plusMonths(maturity);
                LocalDate terminationDate = maturityDate.plusMonths(termination);
                Schedule floatSchedule = this.floatMetaSchedule.generateSchedule(this.referenceDate, maturityDate, terminationDate);
                Schedule fixSchedule = this.fixMetaSchedule.generateSchedule(this.referenceDate, maturityDate, terminationDate);
                double swapRate = Swap.getForwardSwapRate(fixSchedule, floatSchedule, this.model.getForwardCurve(this.forwardCurveName), this.model);
                double matFraction = floatSchedule.getPeriodStart(0);
                double termFraction = floatSchedule.getPeriodEnd(floatSchedule.getNumberOfPeriods() - 1);
                valuesArray[index++] = 0.01 * this.physicalATMSwaptionsVolatilities.getValue(maturity, termination, 0) / tempCube.getValue(termFraction, matFraction, swapRate, VolatilitySurface.QuotingConvention.VOLATILITYNORMAL);
            }
        }
        return new DataTableInterpolated("Base Volatilities", DataTable.TableConvention.MONTHS, this.referenceDate, this.floatMetaSchedule, maturitiesArray, terminationsArray, valuesArray);
    }
}

