/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.model.volatilities;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import net.finmath.marketdata.model.volatilities.VolatilitySurface;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.model.volatilities.VolatilityCube;

public class StaticVolatilityCube
implements VolatilityCube {
    private final String name;
    private final LocalDate referenceDate;
    private final double correlationDecay;
    private final double iborOisDecorrelation;
    private final double value;

    public StaticVolatilityCube(String name, LocalDate referenceDate, double correlationDecay, double iborOisDecorrelation, double value) {
        this.name = name;
        this.referenceDate = referenceDate;
        this.correlationDecay = correlationDecay;
        this.value = value;
        this.iborOisDecorrelation = iborOisDecorrelation;
    }

    public StaticVolatilityCube(String name, LocalDate referenceDate, double correlationDecay, double value) {
        this(name, referenceDate, correlationDecay, 1.0, value);
    }

    public StaticVolatilityCube(String name, LocalDate referenceDate, double value) {
        this(name, referenceDate, 0.0, 1.0, value);
    }

    @Override
    public double getValue(VolatilityCubeModel model, double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.value;
    }

    @Override
    public double getValue(double termination, double maturity, double strike, VolatilitySurface.QuotingConvention quotingConvention) {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    @Override
    public double getCorrelationDecay() {
        return this.correlationDecay;
    }

    @Override
    public double getIborOisDecorrelation() {
        return this.iborOisDecorrelation;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("value", this.value);
        map.put("Inherent correlationDecay", this.correlationDecay);
        map.put("iborOisDecorrelation", this.iborOisDecorrelation);
        return map;
    }

    @Override
    public double getLowestStrike(VolatilityCubeModel model) {
        return Double.NEGATIVE_INFINITY;
    }
}

