/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.products;

import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.annuitymapping.AnnuityMappingFactory;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.products.AbstractSingleSwapRateProduct;
import net.finmath.time.Schedule;

public class AnnuityDummyProduct
extends AbstractSingleSwapRateProduct {
    private final AnnuityMapping.AnnuityMappingType annuityMappingType;
    private final AnnuityMapping annuityMapping;

    public AnnuityDummyProduct(Schedule fixSchedule, Schedule floatSchedule, String discountCurveName, String forwardCurveName, String volatilityCubeName, AnnuityMapping.AnnuityMappingType annuityMappingType) {
        super(fixSchedule, floatSchedule, discountCurveName, forwardCurveName, volatilityCubeName);
        this.annuityMappingType = annuityMappingType;
        this.annuityMapping = null;
    }

    public AnnuityDummyProduct(Schedule fixSchedule, Schedule floatSchedule, String discountCurveName, String forwardCurveName, String volatilityCubeName, AnnuityMapping annuityMapping) {
        super(fixSchedule, floatSchedule, discountCurveName, forwardCurveName, volatilityCubeName);
        this.annuityMapping = annuityMapping;
        this.annuityMappingType = null;
    }

    @Override
    protected double payoffFunction(double swapRate, AnnuityMapping annuityMapping, VolatilityCubeModel model) {
        return annuityMapping.getValue(swapRate);
    }

    @Override
    protected double hedgeWeight(double swapRate, AnnuityMapping annuityMapping, VolatilityCubeModel model) {
        return annuityMapping.getSecondDerivative(swapRate);
    }

    @Override
    protected double singularAddon(double swapRate, AnnuityMapping annuityMapping, VolatilityCubeModel model) {
        return 0.0;
    }

    @Override
    protected AnnuityMapping buildAnnuityMapping(VolatilityCubeModel model) {
        if (this.annuityMapping != null) {
            return this.annuityMapping;
        }
        AnnuityMappingFactory factory = new AnnuityMappingFactory(this.getFixSchedule(), this.getFloatSchedule(), this.getDiscountCurveName(), this.getForwardCurveName(), this.getVolatilityCubeName());
        return factory.build(this.annuityMappingType, model);
    }
}

