/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.singleswaprate.products;

import net.finmath.singleswaprate.annuitymapping.AnnuityMapping;
import net.finmath.singleswaprate.annuitymapping.AnnuityMappingFactory;
import net.finmath.singleswaprate.model.VolatilityCubeModel;
import net.finmath.singleswaprate.products.AbstractSingleSwapRateProduct;
import net.finmath.time.Schedule;

public class CashSettledPayerSwaption
extends AbstractSingleSwapRateProduct {
    private final double strike;
    private final AnnuityMapping.AnnuityMappingType annuityMappingType;

    public CashSettledPayerSwaption(Schedule fixSchedule, Schedule floatSchedule, double strike, String discountCurveName, String forwardCurveName, String volatilityCubeName, AnnuityMapping.AnnuityMappingType annuityMappingType) {
        super(fixSchedule, floatSchedule, discountCurveName, forwardCurveName, volatilityCubeName);
        this.strike = strike;
        this.annuityMappingType = annuityMappingType;
    }

    public CashSettledPayerSwaption(Schedule fixSchedule, Schedule floatSchedule, double strike, String discountCurveName, String forwardCurveName, String volatilityCubeName, AnnuityMapping.AnnuityMappingType annuityMappingType, double replicationLowerBound, double replicationUpperBound, int replicationNumberOfEvaluationPoints) {
        super(fixSchedule, floatSchedule, discountCurveName, forwardCurveName, volatilityCubeName);
        this.strike = strike;
        this.annuityMappingType = annuityMappingType;
        this.setIntegrationParameters(replicationLowerBound, replicationUpperBound, replicationNumberOfEvaluationPoints);
    }

    @Override
    protected double payoffFunction(double swapRate, AnnuityMapping annuityMapping, VolatilityCubeModel model) {
        double value = Math.max(swapRate - this.strike, 0.0);
        return value *= annuityMapping.getValue(swapRate) * this.cashFunction(swapRate);
    }

    @Override
    protected double hedgeWeight(double swapRate, AnnuityMapping annuityMapping, VolatilityCubeModel model) {
        if (!(swapRate > this.strike)) {
            return 0.0;
        }
        double value = annuityMapping.getSecondDerivative(swapRate) * this.cashFunction(swapRate);
        value += 2.0 * annuityMapping.getFirstDerivative(swapRate) * this.cashFunctionFirstDerivative(swapRate);
        value += annuityMapping.getValue(swapRate) * this.cashFunctionSecondDerivative(swapRate);
        value *= swapRate - this.strike;
        return value += (annuityMapping.getFirstDerivative(swapRate) * this.cashFunction(swapRate) + annuityMapping.getValue(swapRate) * this.cashFunctionFirstDerivative(swapRate)) * 2.0;
    }

    @Override
    protected double singularAddon(double swapRate, AnnuityMapping annuityMapping, VolatilityCubeModel model) {
        double value = annuityMapping.getValue(swapRate) * this.cashFunction(swapRate);
        value = swapRate < this.strike ? (value *= this.valueCall(this.strike, model, swapRate)) : (value *= this.valuePut(this.strike, model, swapRate));
        return value;
    }

    @Override
    protected AnnuityMapping buildAnnuityMapping(VolatilityCubeModel model) {
        AnnuityMappingFactory factory = new AnnuityMappingFactory(this.getFixSchedule(), this.getFloatSchedule(), this.getDiscountCurveName(), this.getForwardCurveName(), this.getVolatilityCubeName(), this.strike, this.getIntegrationLowerBound(), this.getIntegrationUpperBound(), this.getIntegrationNumberOfEvaluationPoints());
        return factory.build(this.annuityMappingType, model);
    }

    private double cashFunction(double swapRate) {
        int numberOfPeriods = this.getFixSchedule().getNumberOfPeriods();
        double periodLength = 0.0;
        for (int index = 0; index < numberOfPeriods; ++index) {
            periodLength += this.getFixSchedule().getPeriodLength(index);
        }
        periodLength /= (double)this.getFixSchedule().getNumberOfPeriods();
        if (swapRate == 0.0) {
            return (double)numberOfPeriods * periodLength;
        }
        return (1.0 - Math.pow(1.0 + periodLength * swapRate, -numberOfPeriods)) / swapRate;
    }

    private double cashFunctionFirstDerivative(double swapRate) {
        int numberOfPeriods = this.getFixSchedule().getNumberOfPeriods();
        double periodLength = 0.0;
        for (int index = 0; index < this.getFixSchedule().getNumberOfPeriods(); ++index) {
            periodLength += this.getFixSchedule().getPeriodLength(index);
        }
        periodLength /= (double)this.getFixSchedule().getNumberOfPeriods();
        if (swapRate == 0.0) {
            return (double)(-(numberOfPeriods + 1) * numberOfPeriods / 2) / periodLength / periodLength;
        }
        double value = Math.pow(periodLength * swapRate + 1.0, -numberOfPeriods - 1);
        value *= (double)numberOfPeriods * periodLength / swapRate;
        return value -= this.cashFunction(swapRate) / swapRate;
    }

    private double cashFunctionSecondDerivative(double swapRate) {
        double value;
        int numberOfPeriods = this.getFixSchedule().getNumberOfPeriods();
        double periodLength = 0.0;
        for (int index = 0; index < numberOfPeriods; ++index) {
            periodLength += this.getFixSchedule().getPeriodLength(index);
        }
        periodLength /= (double)numberOfPeriods;
        if (swapRate == 0.0) {
            value = numberOfPeriods * (numberOfPeriods + 1) * (numberOfPeriods + 2);
            value *= periodLength * periodLength * periodLength / 3.0;
        } else {
            value = Math.pow(periodLength * swapRate + 1.0, -numberOfPeriods - 2);
            value *= (double)(-(numberOfPeriods + 1) * numberOfPeriods) * periodLength * periodLength / swapRate;
            value -= this.cashFunctionFirstDerivative(swapRate) * 2.0 / swapRate;
        }
        return value;
    }
}

