/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.stochastic;

import java.io.Serializable;
import java.util.List;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import net.finmath.functions.DoubleTernaryOperator;
import net.finmath.stochastic.ConditionalExpectationEstimator;
import net.finmath.stochastic.RandomOperator;

public interface RandomVariable
extends Serializable {
    public boolean equals(RandomVariable var1);

    public double getFiltrationTime();

    public int getTypePriority();

    public double get(int var1);

    public int size();

    public boolean isDeterministic();

    default public RandomVariable getValues() {
        return this;
    }

    public double[] getRealizations();

    public Double doubleValue();

    public IntToDoubleFunction getOperator();

    public DoubleStream getRealizationsStream();

    public double getMin();

    public double getMax();

    public double getAverage();

    public double getAverage(RandomVariable var1);

    public double getVariance();

    public double getVariance(RandomVariable var1);

    public double getSampleVariance();

    public double getStandardDeviation();

    public double getStandardDeviation(RandomVariable var1);

    public double getStandardError();

    public double getStandardError(RandomVariable var1);

    public double getQuantile(double var1);

    public double getQuantile(double var1, RandomVariable var3);

    public double getQuantileExpectation(double var1, double var3);

    public double[] getHistogram(double[] var1);

    public double[][] getHistogram(int var1, double var2);

    public RandomVariable cache();

    default public RandomVariable appy(RandomOperator operator) {
        return operator.apply(this);
    }

    public RandomVariable apply(DoubleUnaryOperator var1);

    public RandomVariable apply(DoubleBinaryOperator var1, RandomVariable var2);

    public RandomVariable apply(DoubleTernaryOperator var1, RandomVariable var2, RandomVariable var3);

    public RandomVariable cap(double var1);

    public RandomVariable floor(double var1);

    public RandomVariable add(double var1);

    public RandomVariable sub(double var1);

    default public RandomVariable bus(double value) {
        return this.mult(-1.0).add(value);
    }

    public RandomVariable mult(double var1);

    public RandomVariable div(double var1);

    default public RandomVariable vid(double value) {
        return this.invert().mult(value);
    }

    public RandomVariable pow(double var1);

    public RandomVariable average();

    default public RandomVariable expectation() {
        return this.average();
    }

    default public RandomVariable variance() {
        RandomVariable meanDeviation = this.sub(this.average());
        return meanDeviation.squared().average();
    }

    default public RandomVariable covariance(RandomVariable value) {
        return this.sub(this.average()).mult(value.sub(value.average())).average();
    }

    default public RandomVariable getConditionalExpectation(ConditionalExpectationEstimator conditionalExpectationOperator) {
        return conditionalExpectationOperator.getConditionalExpectation(this);
    }

    public RandomVariable squared();

    public RandomVariable sqrt();

    public RandomVariable exp();

    default public RandomVariable expm1() {
        return this.exp().sub(1.0);
    }

    public RandomVariable log();

    public RandomVariable sin();

    public RandomVariable cos();

    public RandomVariable add(RandomVariable var1);

    public RandomVariable sub(RandomVariable var1);

    public RandomVariable bus(RandomVariable var1);

    public RandomVariable mult(RandomVariable var1);

    public RandomVariable div(RandomVariable var1);

    public RandomVariable vid(RandomVariable var1);

    public RandomVariable cap(RandomVariable var1);

    public RandomVariable floor(RandomVariable var1);

    public RandomVariable accrue(RandomVariable var1, double var2);

    public RandomVariable discount(RandomVariable var1, double var2);

    public RandomVariable choose(RandomVariable var1, RandomVariable var2);

    public RandomVariable invert();

    public RandomVariable abs();

    public RandomVariable addProduct(RandomVariable var1, double var2);

    public RandomVariable addProduct(RandomVariable var1, RandomVariable var2);

    public RandomVariable addRatio(RandomVariable var1, RandomVariable var2);

    public RandomVariable subRatio(RandomVariable var1, RandomVariable var2);

    default public RandomVariable addSumProduct(RandomVariable[] factor1, RandomVariable[] factor2) {
        RandomVariable result = this;
        for (int i = 0; i < factor1.length; ++i) {
            result = result.addProduct(factor1[i], factor2[i]);
        }
        return result;
    }

    default public RandomVariable addSumProduct(List<RandomVariable> factor1, List<RandomVariable> factor2) {
        RandomVariable result = this;
        for (int i = 0; i < factor1.size(); ++i) {
            result = result.addProduct(factor1.get(i), factor2.get(i));
        }
        return result;
    }

    public RandomVariable isNaN();
}

