/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.stochastic.operators;

import net.finmath.stochastic.RandomOperator;
import net.finmath.stochastic.RandomVariable;
import net.finmath.stochastic.Scalar;

public class RandomVariableOperator {
    static RandomOperator expectedShortFall(Double percentageLevel) {
        if (percentageLevel < 0.0 || percentageLevel > 1.0) {
            throw new IllegalArgumentException("");
        }
        return x -> {
            if (x.isDeterministic() || x.getVariance() == 0.0) {
                return x;
            }
            double quantileValue = x.getQuantile(percentageLevel);
            RandomVariable indicator = x.sub(quantileValue).choose(Scalar.of(0.0), Scalar.of(1.0));
            RandomVariable averageVar = x.mult(indicator).average().div(percentageLevel);
            return averageVar;
        };
    }
}

