/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import net.finmath.time.daycount.DayCountConvention;
import net.finmath.time.daycount.DayCountConvention_ACT_365;

public class FloatingpointDate {
    private static final long SECONDS_PER_DAY = 31536000L;
    private static DayCountConvention internalDayCounting = new DayCountConvention_ACT_365();

    private FloatingpointDate() {
    }

    public static LocalDateTime getDateFromFloatingPointDate(LocalDateTime referenceDate, double floatingPointDate) {
        if (referenceDate == null) {
            return null;
        }
        Duration duration = Duration.ofSeconds(Math.round(floatingPointDate * 3.1536E7));
        return referenceDate.plus(duration);
    }

    public static double getFloatingPointDateFromDate(LocalDateTime referenceDate, LocalDateTime date) {
        Duration duration = Duration.between(referenceDate, date);
        return (double)duration.getSeconds() / 3.1536E7;
    }

    public static LocalDate getDateFromFloatingPointDate(LocalDate referenceDate, double floatingPointDate) {
        if (referenceDate == null) {
            return null;
        }
        return referenceDate.plusDays((int)Math.round(floatingPointDate * 365.0));
    }

    public static double getFloatingPointDateFromDate(LocalDate referenceDate, LocalDate date) {
        return internalDayCounting.getDaycountFraction(referenceDate, date);
    }
}

