/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.io.Serializable;
import java.time.LocalDate;

public class Period
implements Comparable<Period>,
Serializable {
    private static final long serialVersionUID = 4622662040390651119L;
    private final LocalDate fixing;
    private final LocalDate payment;
    private final LocalDate periodStart;
    private final LocalDate periodEnd;

    public Period(LocalDate fixing, LocalDate payment, LocalDate periodStart, LocalDate periodEnd) {
        this.fixing = fixing;
        this.payment = payment;
        this.periodStart = periodStart;
        this.periodEnd = periodEnd;
    }

    public LocalDate getFixing() {
        return this.fixing;
    }

    public LocalDate getPayment() {
        return this.payment;
    }

    public LocalDate getPeriodStart() {
        return this.periodStart;
    }

    public LocalDate getPeriodEnd() {
        return this.periodEnd;
    }

    @Override
    public int compareTo(Period o) {
        return this.getPeriodEnd().compareTo(o.getPeriodEnd());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fixing == null ? 0 : this.fixing.hashCode());
        result = 31 * result + (this.payment == null ? 0 : this.payment.hashCode());
        result = 31 * result + (this.periodEnd == null ? 0 : this.periodEnd.hashCode());
        result = 31 * result + (this.periodStart == null ? 0 : this.periodStart.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Period other = (Period)obj;
        if (this.fixing == null ? other.fixing != null : !this.fixing.equals(other.fixing)) {
            return false;
        }
        if (this.payment == null ? other.payment != null : !this.payment.equals(other.payment)) {
            return false;
        }
        if (this.periodEnd == null ? other.periodEnd != null : !this.periodEnd.equals(other.periodEnd)) {
            return false;
        }
        if (this.periodStart == null) {
            return other.periodStart == null;
        }
        return this.periodStart.equals(other.periodStart);
    }

    public String toString() {
        return "Period [start=" + this.periodStart + ", end=" + this.periodEnd + ", fixing=" + this.fixing + ", payment=" + this.payment + "]";
    }
}

