/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import net.finmath.time.Period;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleFromPeriods;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarAny;
import net.finmath.time.daycount.DayCountConvention;
import net.finmath.time.daycount.DayCountConvention_30E_360;
import net.finmath.time.daycount.DayCountConvention_30E_360_ISDA;
import net.finmath.time.daycount.DayCountConvention_30U_360;
import net.finmath.time.daycount.DayCountConvention_ACT_360;
import net.finmath.time.daycount.DayCountConvention_ACT_365;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_AFB;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_ISDA;

public class ScheduleGenerator {
    private ScheduleGenerator() {
    }

    public static Schedule createScheduleFromConventions(LocalDate referenceDate, LocalDate startDate, LocalDate maturityDate, Frequency frequency, DaycountConvention daycountConvention, ShortPeriodConvention shortPeriodConvention, BusinessdayCalendar.DateRollConvention dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays, boolean isUseEndOfMonth) {
        ArrayList<Period> periods = new ArrayList<Period>();
        DayCountConvention daycountConventionObject = null;
        switch (daycountConvention) {
            case E30_360_ISDA: {
                daycountConventionObject = new DayCountConvention_30E_360_ISDA();
                break;
            }
            case E30_360: {
                daycountConventionObject = new DayCountConvention_30E_360();
                break;
            }
            case U30_360: {
                daycountConventionObject = new DayCountConvention_30U_360();
                break;
            }
            case ACT_360: {
                daycountConventionObject = new DayCountConvention_ACT_360();
                break;
            }
            case ACT_365: {
                daycountConventionObject = new DayCountConvention_ACT_365();
                break;
            }
            case ACT_ACT_AFB: {
                daycountConventionObject = new DayCountConvention_ACT_ACT_AFB();
                break;
            }
            default: {
                daycountConventionObject = new DayCountConvention_ACT_ACT_ISDA();
            }
        }
        int periodLengthDays = 0;
        int periodLengthWeeks = 0;
        int periodLengthMonth = 0;
        switch (frequency) {
            case DAILY: {
                periodLengthDays = 1;
                break;
            }
            case WEEKLY: {
                periodLengthWeeks = 1;
                break;
            }
            case MONTHLY: {
                periodLengthMonth = 1;
                break;
            }
            case QUARTERLY: {
                periodLengthMonth = 3;
                break;
            }
            case SEMIANNUAL: {
                periodLengthMonth = 6;
                break;
            }
            default: {
                periodLengthMonth = 12;
                break;
            }
            case TENOR: {
                periodLengthMonth = 100000;
            }
        }
        if (periodLengthDays == 0 && periodLengthWeeks == 0 && periodLengthMonth == 0) {
            throw new IllegalArgumentException("ScheduleFromPeriods generation requires positive period length.");
        }
        if (shortPeriodConvention == ShortPeriodConvention.LAST) {
            LocalDate periodStartDateUnadjusted = startDate;
            LocalDate periodEndDateUnadjusted = startDate;
            LocalDate periodStartDate = businessdayCalendar.getAdjustedDate(periodStartDateUnadjusted, dateRollConvention);
            int periodIndex = 0;
            while (periodStartDateUnadjusted.isBefore(maturityDate)) {
                LocalDate periodEndDate;
                periodEndDateUnadjusted = isUseEndOfMonth && startDate.getDayOfMonth() == startDate.lengthOfMonth() ? startDate.plusDays(1L).plusDays(periodLengthDays * periodIndex).plusWeeks(periodLengthWeeks * periodIndex).plusMonths(periodLengthMonth * periodIndex).minusDays(1L) : startDate.plusDays(periodLengthDays * ++periodIndex).plusWeeks(periodLengthWeeks * periodIndex).plusMonths(periodLengthMonth * periodIndex);
                if (periodEndDateUnadjusted.isAfter(maturityDate)) {
                    periodEndDateUnadjusted = maturityDate;
                    periodStartDateUnadjusted = maturityDate;
                }
                if (periodStartDate.compareTo(periodEndDate = businessdayCalendar.getAdjustedDate(periodEndDateUnadjusted, dateRollConvention)) == 0) continue;
                LocalDate fixingDate = businessdayCalendar.getRolledDate(periodStartDate, fixingOffsetDays);
                LocalDate paymentDate = businessdayCalendar.getRolledDate(periodEndDate, paymentOffsetDays);
                periods.add(new Period(fixingDate, paymentDate, periodStartDate, periodEndDate));
                periodStartDate = periodEndDate;
                periodStartDateUnadjusted = periodEndDateUnadjusted;
            }
        } else {
            LocalDate periodStartDateUnadjusted = maturityDate;
            LocalDate periodEndDateUnadjusted = maturityDate;
            LocalDate periodEndDate = businessdayCalendar.getAdjustedDate(periodEndDateUnadjusted, dateRollConvention);
            int periodIndex = 0;
            while (periodEndDateUnadjusted.isAfter(startDate)) {
                LocalDate periodStartDate;
                periodStartDateUnadjusted = isUseEndOfMonth && maturityDate.getDayOfMonth() == maturityDate.lengthOfMonth() ? maturityDate.plusDays(1L).minusDays(periodLengthDays * periodIndex).minusWeeks(periodLengthWeeks * periodIndex).minusMonths(periodLengthMonth * periodIndex).minusDays(1L) : maturityDate.minusDays(periodLengthDays * ++periodIndex).minusWeeks(periodLengthWeeks * periodIndex).minusMonths(periodLengthMonth * periodIndex);
                if (periodStartDateUnadjusted.isBefore(startDate)) {
                    periodStartDateUnadjusted = startDate;
                    periodEndDateUnadjusted = startDate;
                }
                if ((periodStartDate = businessdayCalendar.getAdjustedDate(periodStartDateUnadjusted, dateRollConvention)).compareTo(periodEndDate) == 0) continue;
                LocalDate fixingDate = businessdayCalendar.getRolledDate(periodStartDate, fixingOffsetDays);
                LocalDate paymentDate = businessdayCalendar.getRolledDate(periodEndDate, paymentOffsetDays);
                periods.add(0, new Period(fixingDate, paymentDate, periodStartDate, periodEndDate));
                periodEndDate = periodStartDate;
                periodEndDateUnadjusted = periodStartDateUnadjusted;
            }
        }
        return new ScheduleFromPeriods(referenceDate, periods, daycountConventionObject);
    }

    public static Schedule createScheduleFromConventions(LocalDate referenceDate, LocalDate startDate, LocalDate maturityDate, Frequency frequency, DaycountConvention daycountConvention, ShortPeriodConvention shortPeriodConvention, BusinessdayCalendar.DateRollConvention dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays) {
        return ScheduleGenerator.createScheduleFromConventions(referenceDate, startDate, maturityDate, frequency, daycountConvention, shortPeriodConvention, dateRollConvention, businessdayCalendar, fixingOffsetDays, paymentOffsetDays, false);
    }

    public static Schedule createScheduleFromConventions(LocalDate referenceDate, LocalDate startDate, LocalDate maturityDate, String frequency, String daycountConvention, String shortPeriodConvention, String dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays) {
        return ScheduleGenerator.createScheduleFromConventions(referenceDate, startDate, maturityDate, Frequency.valueOf(frequency.replace("/", "_").toUpperCase()), DaycountConvention.getEnum(daycountConvention), ShortPeriodConvention.valueOf(shortPeriodConvention.replace("/", "_").toUpperCase()), BusinessdayCalendar.DateRollConvention.getEnum(dateRollConvention), businessdayCalendar, fixingOffsetDays, paymentOffsetDays);
    }

    public static Schedule createScheduleFromConventions(Date referenceDate, Date startDate, Date maturityDate, String frequency, String daycountConvention, String shortPeriodConvention, String dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays) {
        return ScheduleGenerator.createScheduleFromConventions(Instant.ofEpochMilli(referenceDate.getTime()).atZone(ZoneId.systemDefault()).toLocalDate(), Instant.ofEpochMilli(startDate.getTime()).atZone(ZoneId.systemDefault()).toLocalDate(), Instant.ofEpochMilli(maturityDate.getTime()).atZone(ZoneId.systemDefault()).toLocalDate(), frequency, daycountConvention, shortPeriodConvention, dateRollConvention, businessdayCalendar, fixingOffsetDays, paymentOffsetDays);
    }

    public static Schedule createScheduleFromConventions(LocalDate referenceDate, LocalDate tradeDate, int spotOffsetDays, String startOffsetString, String maturityString, String frequency, String daycountConvention, String shortPeriodConvention, String dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays) {
        LocalDate spotDate = businessdayCalendar.getRolledDate(tradeDate, spotOffsetDays);
        LocalDate startDate = businessdayCalendar.getDateFromDateAndOffsetCode(spotDate, startOffsetString);
        LocalDate maturityDate = businessdayCalendar.getDateFromDateAndOffsetCode(startDate, maturityString);
        return ScheduleGenerator.createScheduleFromConventions(referenceDate, startDate, maturityDate, frequency, daycountConvention, shortPeriodConvention, dateRollConvention, businessdayCalendar, fixingOffsetDays, paymentOffsetDays);
    }

    public static Schedule createScheduleFromConventions(LocalDate referenceDate, int spotOffsetDays, String startOffsetString, String maturityString, String frequency, String daycountConvention, String shortPeriodConvention, String dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays, boolean isUseEndOfMonth) {
        LocalDate spotDate = businessdayCalendar.getRolledDate(referenceDate, spotOffsetDays);
        LocalDate startDate = businessdayCalendar.getDateFromDateAndOffsetCode(spotDate, startOffsetString);
        LocalDate maturityDate = businessdayCalendar.getDateFromDateAndOffsetCode(startDate, maturityString);
        return ScheduleGenerator.createScheduleFromConventions(referenceDate, startDate, maturityDate, Frequency.valueOf(frequency.replace("/", "_").toUpperCase()), DaycountConvention.getEnum(daycountConvention), ShortPeriodConvention.valueOf(shortPeriodConvention.replace("/", "_").toUpperCase()), BusinessdayCalendar.DateRollConvention.getEnum(dateRollConvention), businessdayCalendar, fixingOffsetDays, paymentOffsetDays, isUseEndOfMonth);
    }

    public static Schedule createScheduleFromConventions(LocalDate referenceDate, int spotOffsetDays, String startOffsetString, String maturityString, String frequency, String daycountConvention, String shortPeriodConvention, String dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays) {
        return ScheduleGenerator.createScheduleFromConventions(referenceDate, referenceDate, spotOffsetDays, startOffsetString, maturityString, frequency, daycountConvention, shortPeriodConvention, dateRollConvention, businessdayCalendar, fixingOffsetDays, paymentOffsetDays);
    }

    public static Schedule createScheduleFromConventions(LocalDate referenceDate, String startOffsetString, String maturityString, String frequency, String daycountConvention, String shortPeriodConvention, String dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays) {
        return ScheduleGenerator.createScheduleFromConventions(referenceDate, 0, startOffsetString, maturityString, frequency, daycountConvention, shortPeriodConvention, dateRollConvention, businessdayCalendar, fixingOffsetDays, paymentOffsetDays);
    }

    public static Schedule createScheduleFromConventions(LocalDate referenceDate, String futureCode, String startOffsetString, String maturityString, String frequency, String daycountConvention, String shortPeriodConvention, String dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays) {
        LocalDate futureExpiryDate;
        int futureExpiryYearsShort = Integer.parseInt(futureCode.substring(futureCode.length() - 2));
        String futureExpiryMonthsString = futureCode.substring(0, futureCode.length() - 2);
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("dd/MMM/yy").toFormatter(Locale.ENGLISH);
        String futureExpiryString = "01/" + futureExpiryMonthsString + "/" + futureExpiryYearsShort;
        try {
            futureExpiryDate = LocalDate.parse(futureExpiryString, formatter);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Error when parsing futureCode " + futureCode + ". Must be of format MMMYY with english month format (e.g. DEC17)");
        }
        while (!futureExpiryDate.getDayOfWeek().equals(DayOfWeek.WEDNESDAY)) {
            futureExpiryDate = futureExpiryDate.plusDays(1L);
        }
        futureExpiryDate = futureExpiryDate.plusWeeks(2L);
        futureExpiryDate = businessdayCalendar.getAdjustedDate(futureExpiryDate, startOffsetString, BusinessdayCalendar.DateRollConvention.FOLLOWING);
        LocalDate maturityDate = businessdayCalendar.getDateFromDateAndOffsetCode(futureExpiryDate, maturityString);
        return ScheduleGenerator.createScheduleFromConventions(referenceDate, futureExpiryDate, maturityDate, Frequency.valueOf(frequency.replace("/", "_").toUpperCase()), DaycountConvention.getEnum(daycountConvention), ShortPeriodConvention.valueOf(shortPeriodConvention.replace("/", "_").toUpperCase()), BusinessdayCalendar.DateRollConvention.getEnum(dateRollConvention), businessdayCalendar, fixingOffsetDays, paymentOffsetDays);
    }

    @Deprecated
    public static Schedule createScheduleFromConventions(LocalDate referenceDate, LocalDate startDate, String frequency, double maturity, String daycountConvention, String shortPeriodConvention, String dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays) {
        LocalDate maturityDate = ScheduleGenerator.createDateFromDateAndOffset(startDate, maturity);
        return ScheduleGenerator.createScheduleFromConventions(referenceDate, startDate, maturityDate, Frequency.valueOf(frequency.toUpperCase()), DaycountConvention.getEnum(daycountConvention), ShortPeriodConvention.valueOf(shortPeriodConvention.toUpperCase()), BusinessdayCalendar.DateRollConvention.getEnum(dateRollConvention), businessdayCalendar, fixingOffsetDays, paymentOffsetDays);
    }

    @Deprecated
    public static Schedule createScheduleFromConventions(LocalDate referenceDate, LocalDate startDate, String frequency, double maturity, String daycountConvention, String shortPeriodConvention) {
        return ScheduleGenerator.createScheduleFromConventions(referenceDate, startDate, frequency, maturity, daycountConvention, shortPeriodConvention, "UNADJUSTED", (BusinessdayCalendar)new BusinessdayCalendarAny(), 0, 0);
    }

    private static LocalDate createDateFromDateAndOffset(LocalDate baseDate, double offsetYearFrac) {
        LocalDate maturity = baseDate.plusYears((int)offsetYearFrac);
        offsetYearFrac = (offsetYearFrac - (double)((int)offsetYearFrac)) * 12.0;
        maturity = maturity.plusMonths((int)offsetYearFrac);
        offsetYearFrac = (offsetYearFrac - (double)((int)offsetYearFrac)) * 30.0;
        maturity = maturity.plusDays((int)Math.round(offsetYearFrac));
        return maturity;
    }

    public static enum DaycountConvention {
        E30_360_ISDA,
        E30_360,
        U30_360,
        ACT_360,
        ACT_365,
        ACT_ACT_AFB,
        ACT_ACT_ISDA,
        ACT_ACT;


        public static DaycountConvention getEnum(String string) {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            switch (string = string.replace('.', ' ').toLowerCase()) {
                case "30e/360 isda": 
                case "e30/360 isda": {
                    return E30_360_ISDA;
                }
                case "30e/360": 
                case "e30/360": 
                case "30/360": {
                    return E30_360;
                }
                case "30u/360": 
                case "u30/360": {
                    return U30_360;
                }
                case "act/360": {
                    return ACT_360;
                }
                case "act/365": 
                case "act/365 fixed": {
                    return ACT_360;
                }
                case "act/act afb": {
                    return ACT_ACT_AFB;
                }
                case "act/act isda": {
                    return ACT_ACT_ISDA;
                }
                case "act/act": {
                    return ACT_ACT;
                }
            }
            return DaycountConvention.valueOf(string.toUpperCase());
        }
    }

    public static enum Frequency {
        DAILY,
        WEEKLY,
        MONTHLY,
        QUARTERLY,
        SEMIANNUAL,
        ANNUAL,
        TENOR;

    }

    public static enum ShortPeriodConvention {
        FIRST,
        LAST;

    }
}

