/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.io.Serializable;
import java.time.LocalDate;
import net.finmath.modelling.descriptor.ScheduleDescriptor;
import net.finmath.time.Schedule;
import net.finmath.time.ScheduleGenerator;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;

public class SchedulePrototype
implements Serializable {
    private static final long serialVersionUID = 1547837440284116534L;
    private final ScheduleGenerator.Frequency frequency;
    private final ScheduleGenerator.DaycountConvention daycountConvention;
    private final ScheduleGenerator.ShortPeriodConvention shortPeriodConvention;
    private final BusinessdayCalendar.DateRollConvention dateRollConvention;
    private final BusinessdayCalendar businessdayCalendar;
    private final int fixingOffsetDays;
    private final int paymentOffsetDays;
    private final boolean isUseEndOfMonth;

    public static String getOffsetCodeFromSchedule(Schedule schedule) {
        double doubleLength = 0.0;
        for (int i = 0; i < schedule.getNumberOfPeriods(); ++i) {
            doubleLength += schedule.getPeriodLength(i);
        }
        doubleLength /= (double)schedule.getNumberOfPeriods();
        int periodLength = (int)Math.round(doubleLength *= 12.0);
        String offsetCode = periodLength + "M";
        return offsetCode;
    }

    public static String getOffsetCodeFromCurveName(String curveName) {
        if (curveName == null || curveName.length() == 0) {
            return null;
        }
        String[] splits = curveName.split("(?<=\\D)(?=\\d)");
        String offsetCode = splits[splits.length - 1];
        if (!Character.isDigit(offsetCode.charAt(0))) {
            return null;
        }
        offsetCode = offsetCode.split("(?<=[A-Za-z])(?=.)", 2)[0];
        offsetCode = offsetCode.replaceAll("[\\W_]", "");
        return offsetCode;
    }

    public SchedulePrototype(ScheduleGenerator.Frequency frequency, ScheduleGenerator.DaycountConvention daycountConvention, ScheduleGenerator.ShortPeriodConvention shortPeriodConvention, BusinessdayCalendar.DateRollConvention dateRollConvention, BusinessdayCalendar businessdayCalendar, int fixingOffsetDays, int paymentOffsetDays, boolean isUseEndOfMonth) {
        this.frequency = frequency;
        this.daycountConvention = daycountConvention;
        this.shortPeriodConvention = shortPeriodConvention;
        this.dateRollConvention = dateRollConvention;
        this.businessdayCalendar = businessdayCalendar;
        this.fixingOffsetDays = fixingOffsetDays;
        this.paymentOffsetDays = paymentOffsetDays;
        this.isUseEndOfMonth = isUseEndOfMonth;
    }

    public ScheduleDescriptor generateScheduleDescriptor(LocalDate startDate, LocalDate endDate) {
        return new ScheduleDescriptor(startDate, endDate, this.getFrequency(), this.getDaycountConvention(), this.getShortPeriodConvention(), this.getDateRollConvention(), this.getBusinessdayCalendar(), this.getFixingOffsetDays(), this.getPaymentOffsetDays(), this.isUseEndOfMonth());
    }

    public Schedule generateSchedule(LocalDate referenceDate, LocalDate startDate, LocalDate endDate) {
        return ScheduleGenerator.createScheduleFromConventions(referenceDate, startDate, endDate, this.getFrequency(), this.getDaycountConvention(), this.getShortPeriodConvention(), this.getDateRollConvention(), this.getBusinessdayCalendar(), this.getFixingOffsetDays(), this.getPaymentOffsetDays(), this.isUseEndOfMonth());
    }

    public Schedule generateSchedule(LocalDate referenceDate, int maturity, int termination) {
        return this.generateSchedule(referenceDate, maturity, termination, OffsetUnit.MONTHS);
    }

    public Schedule generateSchedule(LocalDate referenceDate, int maturity, int termination, OffsetUnit unit) {
        LocalDate endDate;
        LocalDate startDate;
        switch (unit) {
            case YEARS: {
                startDate = referenceDate.plusYears(maturity);
                endDate = startDate.plusYears(termination);
                break;
            }
            case MONTHS: {
                startDate = referenceDate.plusMonths(maturity);
                endDate = startDate.plusMonths(termination);
                break;
            }
            case DAYS: {
                startDate = referenceDate.plusDays(maturity);
                endDate = startDate.plusDays(termination);
                break;
            }
            case WEEKS: {
                startDate = referenceDate.plusDays(maturity * 7);
                endDate = startDate.plusDays(termination * 7);
                break;
            }
            default: {
                startDate = referenceDate.plusMonths(maturity);
                endDate = startDate.plusMonths(termination);
            }
        }
        return this.generateSchedule(referenceDate, startDate, endDate);
    }

    public ScheduleGenerator.Frequency getFrequency() {
        return this.frequency;
    }

    public ScheduleGenerator.DaycountConvention getDaycountConvention() {
        return this.daycountConvention;
    }

    public ScheduleGenerator.ShortPeriodConvention getShortPeriodConvention() {
        return this.shortPeriodConvention;
    }

    public BusinessdayCalendar.DateRollConvention getDateRollConvention() {
        return this.dateRollConvention;
    }

    public BusinessdayCalendar getBusinessdayCalendar() {
        return this.businessdayCalendar;
    }

    public int getFixingOffsetDays() {
        return this.fixingOffsetDays;
    }

    public int getPaymentOffsetDays() {
        return this.paymentOffsetDays;
    }

    public boolean isUseEndOfMonth() {
        return this.isUseEndOfMonth;
    }

    static enum OffsetUnit {
        MONTHS,
        YEARS,
        DAYS,
        WEEKS;

    }
}

