/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.util.ArrayList;
import java.util.function.DoublePredicate;
import java.util.stream.DoubleStream;
import net.finmath.time.TimeDiscretizationFromArray;

public interface TimeDiscretization
extends Iterable<Double> {
    public int getNumberOfTimes();

    public int getNumberOfTimeSteps();

    public double getTime(int var1);

    public double getTimeStep(int var1);

    public int getTimeIndex(double var1);

    public int getTimeIndexNearestLessOrEqual(double var1);

    public int getTimeIndexNearestGreaterOrEqual(double var1);

    default public double getFirstTime() {
        return this.getTime(0);
    }

    default public double getLastTime() {
        return this.getTime(this.getNumberOfTimes() - 1);
    }

    public double[] getAsDoubleArray();

    public ArrayList<Double> getAsArrayList();

    default public DoubleStream doubleStream() {
        return DoubleStream.of(this.getAsDoubleArray());
    }

    public double getTickSize();

    default public TimeDiscretization filter(DoublePredicate timesToKeep) {
        return this.intersect(new TimeDiscretizationFromArray((Iterable<Double>)this.filter(timesToKeep), this.getTickSize()));
    }

    public TimeDiscretization union(TimeDiscretization var1);

    public TimeDiscretization intersect(TimeDiscretization var1);

    public TimeDiscretization getTimeShiftedTimeDiscretization(double var1);
}

