/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.function.DoublePredicate;
import java.util.function.IntToDoubleFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.finmath.time.TimeDiscretization;

public class TimeDiscretizationFromArray
implements Serializable,
TimeDiscretization {
    private static final long serialVersionUID = 6880668325019167781L;
    private static final double timeTickSizeDefault = Double.parseDouble(System.getProperty("net.finmath.functions.TimeDiscretization.timeTickSize", Double.toString(1.1415525114155251E-4)));
    private final double[] timeDiscretization;
    private final double timeTickSize;

    public TimeDiscretizationFromArray(DoubleStream times, double tickSize, boolean allowDuplicates) {
        this.timeTickSize = tickSize;
        times = times.map(this::roundToTimeTickSize);
        if (!allowDuplicates) {
            times = times.distinct();
        }
        this.timeDiscretization = times.sorted().toArray();
    }

    public TimeDiscretizationFromArray(DoubleStream times, double tickSize) {
        this(times, tickSize, false);
    }

    public TimeDiscretizationFromArray(DoubleStream times, boolean allowDuplicates) {
        this(times, timeTickSizeDefault, allowDuplicates);
    }

    public TimeDiscretizationFromArray(DoubleStream times) {
        this(times, timeTickSizeDefault, false);
    }

    public TimeDiscretizationFromArray(Stream<Double> times, double tickSize, boolean allowDuplicates) {
        this(times.mapToDouble(Double::doubleValue), tickSize, allowDuplicates);
    }

    public TimeDiscretizationFromArray(Stream<Double> times, double tickSize) {
        this(times.mapToDouble(Double::doubleValue), tickSize, false);
    }

    public TimeDiscretizationFromArray(Stream<Double> times) {
        this(times.mapToDouble(Double::doubleValue), timeTickSizeDefault, false);
    }

    public TimeDiscretizationFromArray(Iterable<Double> times, double tickSize, boolean allowDuplicates) {
        this(StreamSupport.stream(times.spliterator(), false), tickSize, allowDuplicates);
    }

    public TimeDiscretizationFromArray(Iterable<Double> times, double tickSize) {
        this(times, tickSize, false);
    }

    public TimeDiscretizationFromArray(Iterable<Double> times, boolean allowDuplicates) {
        this(times, timeTickSizeDefault, allowDuplicates);
    }

    public TimeDiscretizationFromArray(Iterable<Double> times) {
        this(times, false);
    }

    public TimeDiscretizationFromArray(double ... times) {
        this(Arrays.stream(times));
    }

    public TimeDiscretizationFromArray(Double[] times) {
        this(Arrays.stream(times));
    }

    public TimeDiscretizationFromArray(Double[] times, double tickSize) {
        this(Arrays.stream(times), tickSize);
    }

    public TimeDiscretizationFromArray(final double initial, int numberOfTimeSteps, final double deltaT) {
        this(IntStream.range(0, numberOfTimeSteps + 1).mapToDouble(new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int n) {
                return initial + (double)n * deltaT;
            }
        }));
    }

    public TimeDiscretizationFromArray(double initial, double last, double deltaT, ShortPeriodLocation shortPeriodLocation) {
        this(TimeDiscretizationFromArray.getEquidistantStreamWithStub(initial, last, deltaT, shortPeriodLocation));
    }

    private static DoubleStream getEquidistantStreamWithStub(final double initial, final double last, final double deltaT, ShortPeriodLocation shortPeriodLocation) {
        int numberOfTimeStepsPlusOne = (int)Math.ceil((last - initial) / deltaT) + 1;
        if (shortPeriodLocation == ShortPeriodLocation.SHORT_PERIOD_AT_END) {
            return IntStream.range(0, numberOfTimeStepsPlusOne).mapToDouble(new IntToDoubleFunction(){

                @Override
                public double applyAsDouble(int n) {
                    return Math.min(last, initial + (double)n * deltaT);
                }
            });
        }
        return IntStream.range(0, numberOfTimeStepsPlusOne).mapToDouble(new IntToDoubleFunction(){

            @Override
            public double applyAsDouble(int n) {
                return Math.max(initial, last - (double)n * deltaT);
            }
        });
    }

    @Override
    public int getNumberOfTimes() {
        return this.timeDiscretization.length;
    }

    @Override
    public int getNumberOfTimeSteps() {
        return this.timeDiscretization.length - 1;
    }

    @Override
    public double getTime(int timeIndex) {
        return this.timeDiscretization[timeIndex];
    }

    @Override
    public double getTimeStep(int timeIndex) {
        return this.timeDiscretization[timeIndex + 1] - this.timeDiscretization[timeIndex];
    }

    @Override
    public int getTimeIndex(double time) {
        return Arrays.binarySearch(this.timeDiscretization, this.roundToTimeTickSize(time));
    }

    @Override
    public int getTimeIndexNearestLessOrEqual(double time) {
        int index = Arrays.binarySearch(this.timeDiscretization, this.roundToTimeTickSize(time));
        if (index < 0) {
            index = -index - 2;
        }
        return index;
    }

    @Override
    public int getTimeIndexNearestGreaterOrEqual(double time) {
        int index = Arrays.binarySearch(this.timeDiscretization, time);
        if (index < 0) {
            index = -index - 1;
        }
        return index;
    }

    @Override
    public double[] getAsDoubleArray() {
        return (double[])this.timeDiscretization.clone();
    }

    @Override
    public ArrayList<Double> getAsArrayList() {
        ArrayList<Double> times = new ArrayList<Double>(this.timeDiscretization.length);
        for (double aTimeDiscretization : this.timeDiscretization) {
            times.add(aTimeDiscretization);
        }
        return times;
    }

    @Override
    public TimeDiscretization getTimeShiftedTimeDiscretization(double timeShift) {
        double[] newTimeDiscretization = new double[this.timeDiscretization.length];
        for (int timeIndex = 0; timeIndex < this.timeDiscretization.length; ++timeIndex) {
            newTimeDiscretization[timeIndex] = this.roundToTimeTickSize(this.timeDiscretization[timeIndex] + timeShift);
        }
        return new TimeDiscretizationFromArray(newTimeDiscretization);
    }

    @Override
    public TimeDiscretization filter(DoublePredicate timesToKeep) {
        return new TimeDiscretizationFromArray(Arrays.stream(this.timeDiscretization).filter(timesToKeep), this.getTickSize());
    }

    @Override
    public TimeDiscretization union(TimeDiscretization that) {
        return new TimeDiscretizationFromArray(Stream.concat(Arrays.stream(this.timeDiscretization).boxed(), Arrays.stream(that.getAsDoubleArray()).boxed()), Math.min(this.timeTickSize, that.getTickSize()));
    }

    @Override
    public TimeDiscretization intersect(TimeDiscretization that) {
        Set<Double> intersectionSet = Arrays.stream(this.timeDiscretization).boxed().collect(Collectors.toSet());
        intersectionSet.retainAll(that.getAsArrayList());
        return new TimeDiscretizationFromArray(intersectionSet, Math.max(this.timeTickSize, that.getTickSize()));
    }

    @Override
    public double getTickSize() {
        return this.timeTickSize;
    }

    @Override
    public Iterator<Double> iterator() {
        return this.getAsArrayList().iterator();
    }

    public String toString() {
        return "TimeDiscretizationFromArray [timeDiscretizationFromArray=" + Arrays.toString(this.timeDiscretization) + ", timeTickSize=" + this.timeTickSize + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.timeDiscretization);
        long temp = Double.doubleToLongBits(this.timeTickSize);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeDiscretizationFromArray other = (TimeDiscretizationFromArray)obj;
        if (!Arrays.equals(this.timeDiscretization, other.timeDiscretization)) {
            return false;
        }
        return Double.doubleToLongBits(this.timeTickSize) == Double.doubleToLongBits(other.timeTickSize);
    }

    private double roundToTimeTickSize(double time) {
        return Math.rint(time / this.timeTickSize) * this.timeTickSize;
    }

    public static enum ShortPeriodLocation {
        SHORT_PERIOD_AT_START,
        SHORT_PERIOD_AT_END;

    }
}

