/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.businessdaycalendar;

import java.time.LocalDate;
import java.util.StringTokenizer;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;

public abstract class AbstractBusinessdayCalendar
implements BusinessdayCalendar {
    private static final long serialVersionUID = -970677373015282512L;

    @Override
    public LocalDate getAdjustedDate(LocalDate date, BusinessdayCalendar.DateRollConvention dateRollConvention) {
        if (dateRollConvention == BusinessdayCalendar.DateRollConvention.UNADJUSTED) {
            return date;
        }
        if (dateRollConvention == BusinessdayCalendar.DateRollConvention.MODIFIED_FOLLOWING) {
            LocalDate adjustedDate = this.getAdjustedDate(date, BusinessdayCalendar.DateRollConvention.FOLLOWING);
            if (adjustedDate.getMonth() != date.getMonth()) {
                return this.getAdjustedDate(date, BusinessdayCalendar.DateRollConvention.PRECEDING);
            }
            return adjustedDate;
        }
        if (dateRollConvention == BusinessdayCalendar.DateRollConvention.MODIFIED_PRECEDING) {
            LocalDate adjustedDate = this.getAdjustedDate(date, BusinessdayCalendar.DateRollConvention.PRECEDING);
            if (adjustedDate.getMonth() != date.getMonth()) {
                return this.getAdjustedDate(date, BusinessdayCalendar.DateRollConvention.FOLLOWING);
            }
            return adjustedDate;
        }
        if (dateRollConvention == BusinessdayCalendar.DateRollConvention.FOLLOWING || dateRollConvention == BusinessdayCalendar.DateRollConvention.PRECEDING) {
            int adjustment = dateRollConvention == BusinessdayCalendar.DateRollConvention.FOLLOWING ? 1 : -1;
            LocalDate adjustedDate = date;
            while (!this.isBusinessday(adjustedDate)) {
                adjustedDate = adjustedDate.plusDays(adjustment);
            }
            return adjustedDate;
        }
        throw new IllegalArgumentException("Unknown date roll convention.");
    }

    @Override
    public LocalDate getRolledDate(LocalDate baseDate, int businessDays) {
        int direction = businessDays >= 0 ? 1 : -1;
        BusinessdayCalendar.DateRollConvention dateRollConvention = direction > 0 ? BusinessdayCalendar.DateRollConvention.FOLLOWING : BusinessdayCalendar.DateRollConvention.PRECEDING;
        LocalDate rolledDate = baseDate;
        while (businessDays != 0) {
            rolledDate = rolledDate.plusDays(direction);
            rolledDate = this.getAdjustedDate(rolledDate, dateRollConvention);
            businessDays -= direction;
        }
        return rolledDate;
    }

    @Override
    public LocalDate getAdjustedDate(LocalDate baseDate, String dateOffsetCode, BusinessdayCalendar.DateRollConvention dateRollConvention) {
        return this.getAdjustedDate(this.getDateFromDateAndOffsetCode(baseDate, dateOffsetCode), dateRollConvention);
    }

    @Override
    public LocalDate getDateFromDateAndOffsetCode(LocalDate baseDate, String dateOffsetCode) {
        dateOffsetCode = dateOffsetCode.trim();
        StringTokenizer tokenizer = new StringTokenizer(dateOffsetCode);
        LocalDate maturityDate = baseDate;
        while (tokenizer.hasMoreTokens()) {
            String maturityCodeSingle = tokenizer.nextToken();
            String[] maturityCodeSingleParts = maturityCodeSingle.split("(?<=[0-9|\\.])(?=[A-Z|a-z])");
            if (maturityCodeSingleParts.length == 1) {
                double maturityValue = Double.valueOf(maturityCodeSingle);
                maturityDate = maturityDate.plusDays((int)Math.round(maturityValue * 365.0));
                continue;
            }
            if (maturityCodeSingleParts.length == 2) {
                int maturityValue = Integer.valueOf(maturityCodeSingleParts[0]);
                BusinessdayCalendar.DateOffsetUnit dateOffsetUnit = BusinessdayCalendar.DateOffsetUnit.getEnum(maturityCodeSingleParts[1]);
                switch (dateOffsetUnit) {
                    case DAYS: {
                        maturityDate = maturityDate.plusDays(maturityValue);
                        break;
                    }
                    case BUSINESS_DAYS: {
                        maturityDate = this.getRolledDate(maturityDate, maturityValue);
                        break;
                    }
                    case WEEKS: {
                        maturityDate = maturityDate.plusWeeks(maturityValue);
                        break;
                    }
                    case MONTHS: {
                        maturityDate = maturityDate.plusMonths(maturityValue);
                        break;
                    }
                    case YEARS: {
                        maturityDate = maturityDate.plusYears(maturityValue);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot handle dateOffsetCode '" + dateOffsetCode + "'.");
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Cannot handle dateOffsetCode '" + dateOffsetCode + "'.");
        }
        return maturityDate;
    }

    public LocalDate[] createDateFromDateAndOffsetCodes(LocalDate baseDate, String[] dateOffsetCodes) {
        LocalDate[] maturityDates = new LocalDate[dateOffsetCodes.length];
        for (int i = 0; i < dateOffsetCodes.length; ++i) {
            String dateOffsetCode = dateOffsetCodes[i].trim();
            StringTokenizer tokenizer = new StringTokenizer(dateOffsetCode);
            LocalDate maturityDate = baseDate;
            while (tokenizer.hasMoreTokens()) {
                String maturityCodeSingle = tokenizer.nextToken();
                String[] maturityCodeSingleParts = maturityCodeSingle.split("(?<=[0-9|\\.])(?=[A-Z|a-z])");
                if (maturityCodeSingleParts.length == 1) {
                    double maturityValue = Double.valueOf(maturityCodeSingle);
                    maturityDate = maturityDate.plusDays((int)Math.round(maturityValue * 365.0));
                    continue;
                }
                if (maturityCodeSingleParts.length == 2) {
                    int maturityValue = Integer.valueOf(maturityCodeSingleParts[0]);
                    BusinessdayCalendar.DateOffsetUnit dateOffsetUnit = BusinessdayCalendar.DateOffsetUnit.getEnum(maturityCodeSingleParts[1]);
                    switch (dateOffsetUnit) {
                        case DAYS: {
                            maturityDate = maturityDate.plusDays(maturityValue);
                            break;
                        }
                        case BUSINESS_DAYS: {
                            maturityDate = this.getRolledDate(maturityDate, maturityValue);
                            break;
                        }
                        case WEEKS: {
                            maturityDate = maturityDate.plusWeeks(maturityValue);
                            break;
                        }
                        case MONTHS: {
                            maturityDate = maturityDate.plusMonths(maturityValue);
                            break;
                        }
                        case YEARS: {
                            maturityDate = maturityDate.plusYears(maturityValue);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Cannot handle dateOffsetCode '" + dateOffsetCode + "'.");
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("Cannot handle dateOffsetCode '" + dateOffsetCode + "'.");
            }
            maturityDates[i] = maturityDate;
        }
        return maturityDates;
    }

    public double[] convertOffsetCodesToTimes(String[] dateOffsetCodes) {
        double[] times = new double[dateOffsetCodes.length];
        for (int i = 0; i < dateOffsetCodes.length; ++i) {
            String dateOffsetCode = dateOffsetCodes[i].trim();
            StringTokenizer tokenizer = new StringTokenizer(dateOffsetCode);
            double time = 0.0;
            while (tokenizer.hasMoreTokens()) {
                String maturityCodeSingle = tokenizer.nextToken();
                String[] maturityCodeSingleParts = maturityCodeSingle.split("(?<=[0-9|\\.])(?=[A-Z|a-z])");
                if (maturityCodeSingleParts.length == 1) {
                    time = Double.valueOf(maturityCodeSingle);
                    continue;
                }
                if (maturityCodeSingleParts.length == 2) {
                    double maturityValue = Double.valueOf(maturityCodeSingleParts[0]);
                    BusinessdayCalendar.DateOffsetUnit dateOffsetUnit = BusinessdayCalendar.DateOffsetUnit.getEnum(maturityCodeSingleParts[1]);
                    switch (dateOffsetUnit) {
                        case DAYS: {
                            time = maturityValue / 365.0;
                            break;
                        }
                        case WEEKS: {
                            time = maturityValue / 52.0;
                            break;
                        }
                        case MONTHS: {
                            time = maturityValue / 12.0;
                            break;
                        }
                        case YEARS: {
                            time = maturityValue;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Cannot handle dateOffsetCode '" + dateOffsetCode + "'.");
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("Cannot handle dateOffsetCode '" + dateOffsetCode + "'.");
            }
            times[i] = time;
        }
        return times;
    }

    public String toString() {
        return "AbstractBusinessdayCalendar";
    }
}

