/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.businessdaycalendar;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Set;
import net.finmath.time.businessdaycalendar.AbstractBusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;

public abstract class BusinessdayCalendarExcludingGivenHolidays
extends AbstractBusinessdayCalendar {
    private static final long serialVersionUID = -7060298609732249650L;
    private final String name;
    private final BusinessdayCalendar baseCalendar;
    private final boolean isExcludeWeekends;

    public BusinessdayCalendarExcludingGivenHolidays(String name, BusinessdayCalendar baseCalendar, boolean isExcludeWeekends) {
        this.name = name;
        this.baseCalendar = baseCalendar;
        this.isExcludeWeekends = isExcludeWeekends;
    }

    public String getName() {
        return this.name;
    }

    public BusinessdayCalendar getBaseCalendar() {
        return this.baseCalendar;
    }

    public boolean isExcludingWeekends() {
        return this.isExcludeWeekends;
    }

    public abstract Set<LocalDate> getHolidays();

    @Override
    public boolean isBusinessday(LocalDate date) {
        return (this.baseCalendar == null || this.baseCalendar.isBusinessday(date)) && this.isExcludingWeekends() && date.getDayOfWeek() != DayOfWeek.SATURDAY && date.getDayOfWeek() != DayOfWeek.SUNDAY && !this.getHolidays().contains(date);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [baseCalendar=" + this.getBaseCalendar() + "]";
    }
}

