/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.businessdaycalendar;

import java.time.LocalDate;
import net.finmath.time.businessdaycalendar.AbstractBusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendarExcludingWeekends;

public class BusinessdayCalendarExcludingTARGETHolidays
extends AbstractBusinessdayCalendar {
    private static final long serialVersionUID = -607317161321548729L;
    private BusinessdayCalendar baseCalendar;
    private final BusinessdayCalendar weekdayCalendar = new BusinessdayCalendarExcludingWeekends();

    public BusinessdayCalendarExcludingTARGETHolidays() {
    }

    public BusinessdayCalendarExcludingTARGETHolidays(BusinessdayCalendar baseCalendar) {
        this.baseCalendar = baseCalendar;
    }

    @Override
    public boolean isBusinessday(LocalDate date) {
        int day = date.getDayOfMonth();
        int month = date.getMonthValue();
        return !(!this.weekdayCalendar.isBusinessday(date) || this.baseCalendar != null && !this.baseCalendar.isBusinessday(date) || day == 1 && month == 1 || BusinessdayCalendarExcludingTARGETHolidays.isEasterSunday(date.plusDays(2L)) || BusinessdayCalendarExcludingTARGETHolidays.isEasterSunday(date.minusDays(1L)) || day == 1 && month == 5 || day == 25 && month == 12 || day == 26 && month == 12);
    }

    public static boolean isEasterSunday(LocalDate date) {
        int y = date.getYear();
        int a = y % 19;
        int b = y / 100;
        int c = y % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int easterSundayMonth = (h + l - 7 * m + 114) / 31;
        int easterSundayDay = (h + l - 7 * m + 114) % 31 + 1;
        int month = date.getMonthValue();
        int day = date.getDayOfMonth();
        return easterSundayMonth == month && easterSundayDay == day;
    }

    @Override
    public String toString() {
        return "BusinessdayCalendarExcludingTARGETHolidays [baseCalendar=" + this.baseCalendar + "]";
    }
}

