/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.businessdaycalendar;

import java.time.DayOfWeek;
import java.time.LocalDate;
import net.finmath.time.businessdaycalendar.AbstractBusinessdayCalendar;
import net.finmath.time.businessdaycalendar.BusinessdayCalendar;

public class BusinessdayCalendarExcludingWeekends
extends AbstractBusinessdayCalendar {
    private static final long serialVersionUID = -664535279499214108L;
    private BusinessdayCalendar baseCalendar;

    public BusinessdayCalendarExcludingWeekends() {
    }

    public BusinessdayCalendarExcludingWeekends(BusinessdayCalendar baseCalendar) {
        this.baseCalendar = baseCalendar;
    }

    @Override
    public boolean isBusinessday(LocalDate date) {
        return (this.baseCalendar == null || this.baseCalendar.isBusinessday(date)) && date.getDayOfWeek() != DayOfWeek.SATURDAY && date.getDayOfWeek() != DayOfWeek.SUNDAY;
    }

    @Override
    public String toString() {
        return "BusinessdayCalendarExcludingWeekends [baseCalendar=" + this.baseCalendar + "]";
    }
}

