/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.io.Serializable;
import java.time.LocalDate;
import net.finmath.time.daycount.DayCountConvention;
import net.finmath.time.daycount.DayCountConvention_30E_360;
import net.finmath.time.daycount.DayCountConvention_30E_360_ISDA;
import net.finmath.time.daycount.DayCountConvention_30U_360;
import net.finmath.time.daycount.DayCountConvention_ACT_360;
import net.finmath.time.daycount.DayCountConvention_ACT_365;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_AFB;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_ISDA;
import net.finmath.time.daycount.DayCountConvention_ACT_ACT_YEARFRAC;

public class DayCountConventionFactory
implements Serializable {
    private static final long serialVersionUID = -3477824315144792988L;

    private DayCountConventionFactory() {
    }

    public static DayCountConvention getDayCountConvention(String convention) {
        if (convention == null) {
            throw new IllegalArgumentException();
        }
        switch (convention = convention.replace('.', ' ').toLowerCase()) {
            case "30e/360 isda": 
            case "e30/360 isda": 
            case "30/360": {
                return new DayCountConvention_30E_360_ISDA();
            }
            case "30e/360": 
            case "e30/360": {
                return new DayCountConvention_30E_360();
            }
            case "30u/360": 
            case "u30/360": {
                return new DayCountConvention_30U_360();
            }
            case "act/360": {
                return new DayCountConvention_ACT_360();
            }
            case "act/365": 
            case "act/365 fixed": {
                return new DayCountConvention_ACT_365();
            }
            case "act/act": 
            case "act/act isda": {
                return new DayCountConvention_ACT_ACT_ISDA();
            }
            case "act/act yearfrac": {
                return new DayCountConvention_ACT_ACT_YEARFRAC();
            }
            case "act/act afb": {
                return new DayCountConvention_ACT_ACT_AFB();
            }
        }
        throw new IllegalArgumentException("Unknow day count convention: " + convention);
    }

    public static double getDaycount(LocalDate startDate, LocalDate endDate, String convention) {
        DayCountConvention daycountConvention = DayCountConventionFactory.getDayCountConvention(convention);
        return daycountConvention.getDaycount(startDate, endDate);
    }

    public static double getDaycountFraction(LocalDate startDate, LocalDate endDate, String convention) {
        DayCountConvention daycountConvention = DayCountConventionFactory.getDayCountConvention(convention);
        return daycountConvention.getDaycountFraction(startDate, endDate);
    }
}

