/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.Month;
import net.finmath.time.daycount.DayCountConvention;

public class DayCountConvention_30U_360
implements DayCountConvention,
Serializable {
    private static final long serialVersionUID = -1362506929067333038L;
    private boolean isEndOfMonth = true;

    public DayCountConvention_30U_360() {
    }

    public DayCountConvention_30U_360(boolean isEndOfMonth) {
        this.isEndOfMonth = isEndOfMonth;
    }

    @Override
    public double getDaycount(LocalDate startDate, LocalDate endDate) {
        if (startDate.isAfter(endDate)) {
            return -this.getDaycount(endDate, startDate);
        }
        int startDateDay = startDate.getDayOfMonth();
        int startDateMonth = startDate.getMonthValue();
        int startDateYear = startDate.getYear();
        int endDateDay = endDate.getDayOfMonth();
        int endDateMonth = endDate.getMonthValue();
        int endDateYear = endDate.getYear();
        if (this.isEndOfMonth && startDate.getMonth() == Month.FEBRUARY && startDate.getDayOfMonth() == startDate.lengthOfMonth() && endDate.getMonth() == Month.FEBRUARY && endDate.getDayOfMonth() == endDate.lengthOfMonth()) {
            endDateDay = 30;
        }
        if (this.isEndOfMonth && startDate.getMonth() == Month.FEBRUARY && startDate.getDayOfMonth() == startDate.lengthOfMonth()) {
            startDateDay = 30;
        }
        if (endDateDay > 30 && startDateDay >= 30) {
            endDateDay = 30;
        }
        startDateDay = Math.min(startDateDay, 30);
        return (double)(endDateYear - startDateYear) * 360.0 + (double)(endDateMonth - startDateMonth) * 30.0 + (double)(endDateDay - startDateDay);
    }

    @Override
    public double getDaycountFraction(LocalDate startDate, LocalDate endDate) {
        return this.getDaycount(startDate, endDate) / 360.0;
    }
}

