/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.time.daycount;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import net.finmath.time.Period;
import net.finmath.time.daycount.DayCountConvention_ACT;

public class DayCountConvention_ACT_ACT_ICMA
extends DayCountConvention_ACT
implements Serializable {
    private static final long serialVersionUID = -6104391125796839417L;
    private final ArrayList<Period> periods;
    private final int frequency;

    public DayCountConvention_ACT_ACT_ICMA(ArrayList<Period> periods, int frequency) {
        this.periods = periods;
        this.frequency = frequency;
    }

    @Override
    public double getDaycountFraction(LocalDate startDate, LocalDate endDate) {
        if (startDate.isAfter(endDate)) {
            return -this.getDaycountFraction(endDate, startDate);
        }
        int periodIndexEndDate = Collections.binarySearch(this.periods, new Period(endDate, endDate, endDate, endDate));
        int periodIndexStartDate = Collections.binarySearch(this.periods, new Period(startDate, startDate, startDate, startDate));
        if (periodIndexEndDate < 0) {
            periodIndexEndDate = -periodIndexEndDate - 1;
        }
        periodIndexStartDate = periodIndexStartDate < 0 ? -periodIndexStartDate - 1 : ++periodIndexStartDate;
        Period startDatePeriod = this.periods.get(periodIndexStartDate);
        Period endDatePeriod = this.periods.get(periodIndexEndDate);
        double periodFraction = this.getDaycount(startDate, startDatePeriod.getPeriodEnd()) / this.getDaycount(startDatePeriod.getPeriodStart(), startDatePeriod.getPeriodEnd()) + this.getDaycount(endDatePeriod.getPeriodStart(), endDate) / this.getDaycount(endDatePeriod.getPeriodStart(), endDatePeriod.getPeriodEnd()) + (double)(periodIndexEndDate - periodIndexStartDate) - 1.0;
        return periodFraction / (double)this.frequency;
    }
}

