/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries;

import java.util.Iterator;
import net.finmath.timeseries.TimeSeries;

public class TimeSeriesFromArray
implements TimeSeries {
    private final double[] times;
    private final double[] values;

    public TimeSeriesFromArray(double[] times, double[] values) {
        this.times = times;
        this.values = values;
    }

    @Override
    public double getTime(int index) {
        return this.times[index];
    }

    @Override
    public double getValue(int index) {
        return this.values[index];
    }

    @Override
    public int getNumberOfTimePoints() {
        return this.times.length;
    }

    @Override
    public Iterable<Double> getValues() {
        return new Iterable<Double>(){
            private int index = 0;

            @Override
            public Iterator<Double> iterator() {
                return new Iterator<Double>(){

                    @Override
                    public boolean hasNext() {
                        return index < TimeSeriesFromArray.this.getNumberOfTimePoints();
                    }

                    @Override
                    public Double next() {
                        return TimeSeriesFromArray.this.getValue(index++);
                    }
                };
            }
        };
    }
}

