/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries.models.parametric;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.finmath.optimizer.LevenbergMarquardt;
import net.finmath.timeseries.HistoricalSimulationModel;
import net.finmath.timeseries.TimeSeries;
import net.finmath.timeseries.TimeSeriesModelParametric;
import net.finmath.timeseries.TimeSeriesView;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.SimplePointChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.CMAESOptimizer;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;

public class ARMAGARCH
implements TimeSeriesModelParametric,
HistoricalSimulationModel {
    private final TimeSeries timeSeries;
    private final int maxIterations = 10000000;
    private final String[] parameterNames = new String[]{"omega", "alpha", "beta", "theta", "mu", "phi"};
    private final double[] parameterGuess = new double[]{0.1, 0.3, 0.3, 0.0, 0.0, 0.0};
    private final double[] parameterStep = new double[]{0.001, 0.001, 0.001, 0.001, 1.0E-4, 0.001};
    private final double[] lowerBound;
    private final double[] upperBound;

    public ARMAGARCH(TimeSeries timeSeries) {
        this.timeSeries = timeSeries;
        this.lowerBound = new double[]{0.0, 0.0, 0.0, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        this.upperBound = new double[]{Double.POSITIVE_INFINITY, 1.0, 1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY};
    }

    public double getLogLikelihoodForParameters(double[] parameters) {
        double omega = parameters[0];
        double alpha = parameters[1];
        double beta = parameters[2];
        double theta = parameters[3];
        double mu = parameters[4];
        double phi = parameters[5];
        double logLikelihood = 0.0;
        double volScaling = 1.0;
        double evalPrev = 0.0;
        double eval = 1.0 * Math.log(this.timeSeries.getValue(1) / this.timeSeries.getValue(0));
        if (Double.isInfinite(eval) || Double.isNaN(eval)) {
            eval = 0.0;
        }
        double h = omega / (1.0 - alpha - beta);
        double m = 0.0;
        logLikelihood += -Math.log(h) - 2.0 * Math.log(Math.abs(this.timeSeries.getValue(1)) / 1.0) - eval * eval / h;
        int length = this.timeSeries.getNumberOfTimePoints();
        for (int i = 1; i < length - 1; ++i) {
            m = -mu - theta * m + eval - phi * evalPrev;
            h = omega + alpha * m * m + beta * h;
            double value1 = this.timeSeries.getValue(i);
            double value2 = this.timeSeries.getValue(i + 1);
            double evalNext = 1.0 * Math.log(value2 / value1);
            if (Double.isInfinite(evalNext) || Double.isNaN(evalNext)) {
                evalNext = 0.0;
            }
            double mNext = -mu - theta * m + evalNext - phi * eval;
            logLikelihood += -Math.log(h) - 2.0 * Math.log(Math.abs(value2) / 1.0) - mNext * mNext / h;
            evalPrev = eval;
            eval = evalNext;
        }
        logLikelihood += -Math.log(Math.PI * 2) * (double)(length - 1);
        return logLikelihood *= 0.5;
    }

    public double getLastResidualForParameters(double[] parameters) {
        double omega = parameters[0];
        double alpha = parameters[1];
        double beta = parameters[2];
        double theta = parameters[3];
        double mu = parameters[4];
        double phi = parameters[5];
        double evalPrev = 0.0;
        double volScaling = 1.0;
        double h = omega / (1.0 - alpha - beta);
        double m = 0.0;
        int length = this.timeSeries.getNumberOfTimePoints();
        for (int i = 1; i < length - 1; ++i) {
            double eval = 1.0 * Math.log(this.timeSeries.getValue(i) / this.timeSeries.getValue(i - 1));
            if (Double.isInfinite(eval) || Double.isNaN(eval)) {
                eval = 0.0;
            }
            m = -mu - theta * m + eval - phi * evalPrev;
            h = omega + alpha * m * m + beta * h;
            evalPrev = eval;
        }
        return h;
    }

    public double[] getSzenarios(double[] parameters) {
        double omega = parameters[0];
        double alpha = parameters[1];
        double beta = parameters[2];
        double theta = parameters[3];
        double mu = parameters[4];
        double phi = parameters[5];
        ArrayList<Double> szenarios = new ArrayList<Double>();
        double volScaling = 1.0;
        double evalPrev = 0.0;
        double h = omega / (1.0 - alpha - beta);
        double m = 0.0;
        double vol = Math.sqrt(h) / 1.0;
        for (int i = 1; i <= this.timeSeries.getNumberOfTimePoints() - 1; ++i) {
            double y = Math.log(this.timeSeries.getValue(i) / this.timeSeries.getValue(i - 1));
            if (Double.isInfinite(y) || Double.isNaN(y)) {
                y = 0.0;
            }
            double eval = 1.0 * y;
            m = -mu - theta * m + eval - phi * evalPrev;
            double value = m / 1.0 / vol;
            szenarios.add(value);
            h = omega + alpha * m * m + beta * h;
            vol = Math.sqrt(h) / 1.0;
            evalPrev = eval;
        }
        Collections.sort(szenarios);
        double[] szenariosArray = new double[szenarios.size()];
        for (int i = 0; i < szenarios.size(); ++i) {
            szenariosArray[i] = (Double)szenarios.get(i) * vol;
        }
        return szenariosArray;
    }

    public double[] getQuantilPredictionsForParameters(double[] parameters, double[] quantiles) {
        double[] szenarios = this.getSzenarios(parameters);
        double[] quantileValues = new double[quantiles.length];
        for (int i = 0; i < quantiles.length; ++i) {
            double quantileValue;
            double quantile = quantiles[i];
            double quantileIndex = (double)(szenarios.length + 1) * quantile - 1.0;
            int quantileIndexLo = (int)quantileIndex;
            int quantileIndexHi = quantileIndexLo + 1;
            double szenarioRelativeChange = szenarios.length > 0 ? Math.exp(((double)quantileIndexHi - quantileIndex) * szenarios[Math.max(quantileIndexLo, 0)] + (quantileIndex - (double)quantileIndexLo) * szenarios[Math.min(quantileIndexHi, szenarios.length - 1)]) : 1.0;
            quantileValues[i] = quantileValue = this.timeSeries.getValue(this.timeSeries.getNumberOfTimePoints() - 1) * szenarioRelativeChange;
        }
        return quantileValues;
    }

    @Override
    public Map<String, Object> getBestParameters() {
        return this.getBestParameters(null);
    }

    @Override
    public Map<String, Object> getBestParameters(Map<String, Object> guess) {
        class GARCHMaxLikelihoodFunction
        implements MultivariateFunction,
        Serializable {
            private static final long serialVersionUID = 7072187082052755854L;

            GARCHMaxLikelihoodFunction() {
            }

            public double value(double[] variables) {
                double omega = variables[0];
                double alpha = variables[1];
                double beta = variables[2];
                double theta = variables[3];
                double mu = variables[4];
                double phi = variables[5];
                double logLikelihood = ARMAGARCH.this.getLogLikelihoodForParameters(variables);
                logLikelihood -= Math.max(1.0E-30 - omega, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(1.0E-30 - alpha, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(alpha - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
                logLikelihood -= Math.max(1.0E-30 - beta, 0.0) / 1.0E-30;
                return logLikelihood -= Math.max(beta - 1.0 + 1.0E-30, 0.0) / 1.0E-30;
            }
        }
        final GARCHMaxLikelihoodFunction objectiveFunction = new GARCHMaxLikelihoodFunction();
        final double[] guessParameters = new double[this.parameterGuess.length];
        System.arraycopy(this.parameterGuess, 0, guessParameters, 0, this.parameterGuess.length);
        if (guess != null) {
            guessParameters[0] = (Double)guess.get("Omega");
            guessParameters[1] = (Double)guess.get("Alpha");
            guessParameters[2] = (Double)guess.get("Beta");
            guessParameters[3] = (Double)guess.get("Theta");
            guessParameters[4] = (Double)guess.get("Mu");
            guessParameters[5] = (Double)guess.get("Phi");
        }
        LevenbergMarquardt lm = new LevenbergMarquardt(guessParameters, new double[]{1000.0}, 1000000000, 2){
            private static final long serialVersionUID = -8844232820888815090L;
            {
                super(initialParameters, targetValues, maxIteration, numberOfThreads);
            }

            @Override
            public void setValues(double[] parameters, double[] values) {
                values[0] = objectiveFunction.value(parameters);
            }
        };
        double[] bestParameters = null;
        boolean isUseLM = false;
        CMAESOptimizer optimizer2 = new CMAESOptimizer(10000000, Double.POSITIVE_INFINITY, true, 0, 0, (RandomGenerator)new MersenneTwister(3141), false, (ConvergenceChecker)new SimplePointChecker(0.0, 0.0)){
            {
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }

            public double computeObjectiveValue(double[] params) {
                return objectiveFunction.value(params);
            }

            public GoalType getGoalType() {
                return GoalType.MAXIMIZE;
            }

            public double[] getStartPoint() {
                return guessParameters;
            }

            public double[] getLowerBound() {
                return ARMAGARCH.this.lowerBound;
            }

            public double[] getUpperBound() {
                return ARMAGARCH.this.upperBound;
            }
        };
        try {
            PointValuePair result = optimizer2.optimize(new OptimizationData[]{new CMAESOptimizer.PopulationSize((int)(4.0 + 3.0 * Math.log(guessParameters.length))), new CMAESOptimizer.Sigma(this.parameterStep)});
            bestParameters = result.getPoint();
        }
        catch (MathIllegalStateException e) {
            System.out.println("Solver failed");
            bestParameters = guessParameters;
        }
        double omega = bestParameters[0];
        double alpha = bestParameters[1];
        double beta = bestParameters[2];
        double theta = bestParameters[3];
        double mu = bestParameters[4];
        double phi = bestParameters[5];
        double[] quantiles = new double[]{0.005, 0.01, 0.02, 0.05, 0.5};
        double[] quantileValues = this.getQuantilPredictionsForParameters(bestParameters, quantiles);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("parameters", bestParameters);
        results.put("Omega", omega);
        results.put("Alpha", alpha);
        results.put("Beta", beta);
        results.put("Theta", theta);
        results.put("Mu", mu);
        results.put("Phi", phi);
        results.put("Szenarios", this.getSzenarios(bestParameters));
        results.put("Likelihood", this.getLogLikelihoodForParameters(bestParameters));
        results.put("Vol", Math.sqrt(this.getLastResidualForParameters(bestParameters)));
        results.put("Quantile=05%", quantileValues[0]);
        results.put("Quantile=1%", quantileValues[1]);
        results.put("Quantile=2%", quantileValues[2]);
        results.put("Quantile=5%", quantileValues[3]);
        results.put("Quantile=50%", quantileValues[4]);
        return results;
    }

    private static double restrictToOpenSet(double value, double lowerBond, double upperBound) {
        value = Math.max(value, lowerBond * (1.0 + Math.signum(lowerBond) * 1.0E-15) + 1.0E-15);
        value = Math.min(value, upperBound * (1.0 - Math.signum(upperBound) * 1.0E-15) - 1.0E-15);
        return value;
    }

    @Override
    public TimeSeriesModelParametric getCloneCalibrated(TimeSeries timeSeries) {
        return new ARMAGARCH(timeSeries);
    }

    @Override
    public HistoricalSimulationModel getCloneWithWindow(int windowIndexStart, int windowIndexEnd) {
        return new ARMAGARCH(new TimeSeriesView(this.timeSeries, windowIndexStart, windowIndexEnd));
    }

    @Override
    public double[] getParameters() {
        return (double[])this.getBestParameters().get("parameters");
    }

    @Override
    public String[] getParameterNames() {
        return this.parameterNames;
    }
}

