/*
 * Decompiled with CFR 0.152.
 */
package net.finmath.timeseries.models.parametric;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.finmath.timeseries.HistoricalSimulationModel;

public class SimpleHistroricalSimulation
implements HistoricalSimulationModel {
    private final double[] values;
    private final int windowIndexStart;
    private final int windowIndexEnd;

    public SimpleHistroricalSimulation(double[] values) {
        this.values = values;
        this.windowIndexStart = 0;
        this.windowIndexEnd = values.length - 1;
    }

    public SimpleHistroricalSimulation(double[] values, int windowIndexStart, int windowIndexEnd) {
        this.values = values;
        this.windowIndexStart = windowIndexStart;
        this.windowIndexEnd = windowIndexEnd;
    }

    @Override
    public HistoricalSimulationModel getCloneWithWindow(int windowIndexStart, int windowIndexEnd) {
        return new SimpleHistroricalSimulation(this.values, windowIndexStart, windowIndexEnd);
    }

    public double[] getSzenarios(int relAbsFlag) {
        double[] szenarios = new double[this.windowIndexEnd - this.windowIndexStart + 1 - 1];
        for (int i = this.windowIndexStart + 1; i <= this.windowIndexEnd; ++i) {
            double y = relAbsFlag == 1 ? Math.log(this.values[i] / this.values[i - 1]) : this.values[i] - this.values[i - 1];
            szenarios[i - this.windowIndexStart - 1] = y;
        }
        Arrays.sort(szenarios);
        return szenarios;
    }

    public double[] getQuantilPredictions(int relAbsFlag, double[] quantiles) {
        double[] szenarios = this.getSzenarios(relAbsFlag);
        double[] quantileValues = new double[quantiles.length];
        for (int i = 0; i < quantiles.length; ++i) {
            double quantileValue;
            double szenarioChange;
            double quantile = quantiles[i];
            double quantileIndex = (double)szenarios.length * quantile - 1.0;
            int quantileIndexLo = (int)quantileIndex;
            int quantileIndexHi = quantileIndexLo + 1;
            double evalLo = szenarios[Math.max(quantileIndexLo, 0)];
            double evalHi = szenarios[Math.max(quantileIndexHi, 0)];
            if (relAbsFlag == 1) {
                szenarioChange = ((double)quantileIndexHi - quantileIndex) * Math.exp(evalLo) + (quantileIndex - (double)quantileIndexLo) * Math.exp(evalHi);
                quantileValues[i] = quantileValue = this.values[this.windowIndexEnd] * szenarioChange;
                continue;
            }
            szenarioChange = ((double)quantileIndexHi - quantileIndex) * evalLo + (quantileIndex - (double)quantileIndexLo) * evalHi;
            quantileValues[i] = quantileValue = this.values[this.windowIndexEnd] + szenarioChange;
        }
        return quantileValues;
    }

    @Override
    public Map<String, Object> getBestParameters() {
        return this.getBestParameters(null);
    }

    @Override
    public Map<String, Object> getBestParameters(Map<String, Object> guess) {
        boolean relAbsFlag = true;
        double[] quantiles = new double[]{0.01, 0.05, 0.5};
        double[] quantileValues = this.getQuantilPredictions(1, quantiles);
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("Szenarios", this.getSzenarios(1));
        results.put("Quantile=1%", quantileValues[0]);
        results.put("Quantile=5%", quantileValues[1]);
        results.put("Quantile=50%", quantileValues[2]);
        return results;
    }
}

